/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.Bundle;
import org.netbeans.modules.web.browser.api.WebBrowserFactoryDescriptor;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.api.WebBrowserPane;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.spi.BrowserURLMapperImplementation;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public final class WebBrowser {
    private WebBrowserFactoryDescriptor factoryDesc;
    private Preferences prefs = null;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static RequestProcessor RP = new RequestProcessor();
    private static Map<Project, BrowserURLMapperImplementation.BrowserURLMapper> browserMappings = new WeakHashMap<Project, BrowserURLMapperImplementation.BrowserURLMapper>();
    private static final String CHROME_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_chrome_16x.png";
    private static final String CHROME_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_chrome_24x.png";
    private static final String FIREFOX_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_firefox_16x.png";
    private static final String FIREFOX_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_firefox_24x.png";
    private static final String CHROMIUM_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_chromium_16x.png";
    private static final String CHROMIUM_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_chromium_24x.png";
    private static final String IE_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_ie_16x.png";
    private static final String IE_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_ie_24x.png";
    private static final String SAFARI_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_safari_16x.png";
    private static final String SAFARI_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_safari_24x.png";
    private static final String GENERIC_SMALL = "org/netbeans/modules/web/browser/ui/resources/browser_generic_16x.png";
    private static final String GENERIC_LARGE = "org/netbeans/modules/web/browser/ui/resources/browser_generic_24x.png";

    WebBrowser(WebBrowserFactoryDescriptor factoryDesc) {
        this.factoryDesc = factoryDesc;
    }

    private WebBrowser() {
        this.refreshDelegate();
        this.addListener();
    }

    private void refreshDelegate() {
        WebBrowser ideBrowser = WebBrowsers.getInstance().getPreferred();
        this.factoryDesc = new WebBrowserFactoryDescriptor(ideBrowser.getFactoryDesc(), "default", Bundle.WebBrowsers_idebrowser());
        this.changeSupport.fireChange();
    }

    private void addListener() {
        assert (this.prefs == null);
        this.prefs = NbPreferences.forModule(IDESettings.class);
        this.prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("WWWBrowser".equals(evt.getKey())) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            WebBrowser.this.refreshDelegate();
                        }
                    });
                }
            }
        });
        if (this.factoryDesc.getFactory() instanceof ExtWebBrowser) {
            ExtWebBrowser fa = (ExtWebBrowser)this.factoryDesc.getFactory();
            fa.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("privateBrowserFamilyId")) {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                WebBrowser.this.refreshDelegate();
                            }
                        });
                    }
                }
            });
        }
    }

    static WebBrowser createIDEGlobalDelegate() {
        return new WebBrowser();
    }

    public String getId() {
        return this.factoryDesc.getId();
    }

    public boolean hasNetBeansIntegration() {
        return this.factoryDesc.hasNetBeansIntegration();
    }

    public String getName() {
        return this.factoryDesc.getName();
    }

    public Image getIconImage(boolean small) {
        Image im = this.factoryDesc.getIconImage(small);
        if (im == null) {
            ImageIcon icon = ImageUtilities.loadImageIcon((String)WebBrowser.getIconFile(this.getBrowserFamily(), small), (boolean)true);
            im = ImageUtilities.icon2Image((Icon)icon);
        }
        if (!this.hasNetBeansIntegration() || this.factoryDesc.getBrowserFamily() != BrowserFamilyId.JAVAFX_WEBVIEW) {
            // empty if block
        }
        return im;
    }

    public BrowserFamilyId getBrowserFamily() {
        return this.factoryDesc.getBrowserFamily();
    }

    public boolean isEmbedded() {
        return this.getBrowserFamily() == BrowserFamilyId.JAVAFX_WEBVIEW;
    }

    public URL toBrowserURL(Project p, FileObject projectFile, URL serverURL) {
        BrowserURLMapperImplementation impl = this.factoryDesc.getBrowserURLMapper();
        if (impl != null) {
            BrowserURLMapperImplementation.BrowserURLMapper m = impl.toBrowser(p, projectFile, serverURL);
            if (m != null) {
                browserMappings.put(p, m);
                String url = WebUtils.urlToString((URL)serverURL);
                if (url.startsWith(m.getServerURLRoot())) {
                    url = m.getBrowserURLRoot() + url.substring(m.getServerURLRoot().length());
                    return WebUtils.stringToUrl((String)url);
                }
            } else {
                browserMappings.remove(p);
            }
        }
        return serverURL;
    }

    public URL fromBrowserURL(Project p, URL serverURL) {
        BrowserURLMapperImplementation.BrowserURLMapper m = browserMappings.get(p);
        if (m != null) {
            String url = WebUtils.urlToString((URL)serverURL);
            if (url.startsWith(m.getBrowserURLRoot())) {
                url = m.getServerURLRoot() + url.substring(m.getBrowserURLRoot().length());
            }
            return WebUtils.stringToUrl((String)url);
        }
        return serverURL;
    }

    public WebBrowserPane createNewBrowserPane() {
        return this.createNewBrowserPane(true);
    }

    public WebBrowserPane createNewBrowserPane(WebBrowserFeatures features) {
        return this.createNewBrowserPane(features, true);
    }

    public WebBrowserPane createNewBrowserPane(boolean wrapEmbeddedBrowserInTopComponent) {
        return this.createNewBrowserPane(new WebBrowserFeatures(), wrapEmbeddedBrowserInTopComponent);
    }

    public WebBrowserPane createNewBrowserPane(WebBrowserFeatures features, boolean wrapEmbeddedBrowserInTopComponent) {
        return new WebBrowserPane(features, this.factoryDesc, wrapEmbeddedBrowserInTopComponent);
    }

    public HtmlBrowser.Factory getHtmlBrowserFactory() {
        return this.factoryDesc.getFactory();
    }

    WebBrowserFactoryDescriptor getFactoryDesc() {
        return this.factoryDesc;
    }

    private static String getIconFile(BrowserFamilyId browserFamily, boolean small) {
        switch (browserFamily) {
            case CHROME: {
                return small ? CHROME_SMALL : CHROME_LARGE;
            }
            case FIREFOX: {
                return small ? FIREFOX_SMALL : FIREFOX_LARGE;
            }
            case CHROMIUM: {
                return small ? CHROMIUM_SMALL : CHROMIUM_LARGE;
            }
            case IE: {
                return small ? IE_SMALL : IE_LARGE;
            }
            case SAFARI: {
                return small ? SAFARI_SMALL : SAFARI_LARGE;
            }
        }
        return small ? GENERIC_SMALL : GENERIC_LARGE;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }
}

