/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.StringUtils;
import org.netbeans.modules.javascript2.requirejs.ui.LocalPathCell;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class RequireJsPanel
extends JPanel
implements HelpCtx.Provider {
    static final String DEFAULT_LOCAL_PATH = "";
    static final int COLUMN_MAPPING_PATH = 0;
    static final int COLUMN_LOCAL_PATH = 1;
    private final Project project;
    private final ProjectCustomizer.Category category;
    private final PathMappingTableModel pathMappingTableModel;
    private boolean isSupportEnabled;
    private JCheckBox enabledCheckBox;
    private JLabel enabledInfoLabel;
    private JButton newPathMappingButton;
    private JLabel pathMappingInfoLabel;
    private JLabel pathMappingLabel;
    private JScrollPane pathMappingScrollPane;
    private JTable pathMappingTable;
    private JButton removePathMappingButton;

    public RequireJsPanel(ProjectCustomizer.Category category, Project project) {
        this.project = project;
        this.category = category;
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequireJsPanel.this.saveData();
            }
        });
        this.initComponents();
        String[] columnNames = new String[]{NbBundle.getMessage(RequireJsPanel.class, (String)"LBL_Mapping"), NbBundle.getMessage(RequireJsPanel.class, (String)"LBL_LocalPath")};
        this.pathMappingTableModel = new PathMappingTableModel(columnNames, this.getPathMappingsData());
        this.init();
    }

    public boolean isSupportEnabled() {
        return this.enabledCheckBox.isSelected();
    }

    public void setSupportEnabled(boolean enabled) {
        this.enabledCheckBox.setSelected(enabled);
        this.pathMappingLabel.setEnabled(enabled);
        this.pathMappingInfoLabel.setEnabled(enabled);
        this.pathMappingScrollPane.setEnabled(enabled);
        this.pathMappingTable.setEnabled(enabled);
        this.handleButtonStates();
    }

    private void init() {
        this.isSupportEnabled = RequireJsPreferences.getBoolean(this.project, RequireJsPreferences.ENABLED);
        this.setSupportEnabled(this.isSupportEnabled);
        this.pathMappingTable.setModel(this.pathMappingTableModel);
        this.pathMappingTable.setDefaultRenderer(LocalPathCell.class, new LocalPathCellRenderer());
        this.pathMappingTable.addMouseListener(new LocalPathCellMouseListener(this.pathMappingTable));
        this.pathMappingTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                RequireJsPanel.this.handleButtonStates();
            }
        });
        this.pathMappingTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RequireJsPanel.this.handleButtonStates();
            }
        });
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RequireJsPanel.this.isSupportEnabled = e.getStateChange() == 1;
                RequireJsPanel.this.setSupportEnabled(RequireJsPanel.this.isSupportEnabled);
            }
        });
    }

    private void saveData() {
        RequireJsPreferences.putBoolean(this.project, RequireJsPreferences.ENABLED, this.isSupportEnabled());
        RequireJsPreferences.storeMappings(this.project, this.getPathMappings());
    }

    void handleButtonStates() {
        if (this.isSupportEnabled) {
            this.removePathMappingButton.setEnabled(this.isTableRowSelected());
            this.newPathMappingButton.setEnabled(this.pathMappingTableModel.isLastServerPathFilled());
        } else {
            this.removePathMappingButton.setEnabled(false);
            this.newPathMappingButton.setEnabled(false);
        }
    }

    private boolean isTableRowSelected() {
        return this.getTableSelectedRow() != -1;
    }

    private void initComponents() {
        this.enabledCheckBox = new JCheckBox();
        this.enabledInfoLabel = new JLabel();
        this.pathMappingLabel = new JLabel();
        this.pathMappingScrollPane = new JScrollPane();
        this.pathMappingTable = new JTable();
        this.newPathMappingButton = new JButton();
        this.removePathMappingButton = new JButton();
        this.pathMappingInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.enabledCheckBox.text"));
        this.enabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequireJsPanel.this.enabledCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.enabledInfoLabel, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.enabledInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.pathMappingLabel, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.pathMappingLabel.text"));
        this.pathMappingTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.pathMappingScrollPane.setViewportView(this.pathMappingTable);
        Mnemonics.setLocalizedText((AbstractButton)this.newPathMappingButton, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.newPathMappingButton.text"));
        this.newPathMappingButton.setEnabled(false);
        this.newPathMappingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequireJsPanel.this.newPathMappingButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removePathMappingButton, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.removePathMappingButton.text"));
        this.removePathMappingButton.setEnabled(false);
        this.removePathMappingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequireJsPanel.this.removePathMappingButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.pathMappingInfoLabel, (String)NbBundle.getMessage(RequireJsPanel.class, (String)"RequireJsPanel.pathMappingInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enabledCheckBox).addComponent(this.enabledInfoLabel).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pathMappingScrollPane, -1, 516, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.removePathMappingButton, -1, -1, Short.MAX_VALUE).addComponent(this.newPathMappingButton, -1, -1, Short.MAX_VALUE))).addComponent(this.pathMappingLabel).addComponent(this.pathMappingInfoLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enabledInfoLabel).addGap(18, 18, 18).addComponent(this.pathMappingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.newPathMappingButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removePathMappingButton).addGap(0, 167, Short.MAX_VALUE)).addComponent(this.pathMappingScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pathMappingInfoLabel).addGap(155, 155, 155)));
    }

    private void newPathMappingButtonActionPerformed(ActionEvent evt) {
        this.pathMappingTableModel.addRow(new Object[]{null, new LocalPathCell(DEFAULT_LOCAL_PATH)});
    }

    private void removePathMappingButtonActionPerformed(ActionEvent evt) {
        assert (this.getTableSelectedRow() != -1) : "A table row must be selected";
        while (this.getTableSelectedRow() != -1) {
            this.pathMappingTableModel.removeRow(this.getTableSelectedRow());
        }
        if (this.pathMappingTableModel.getRowCount() == 0) {
            this.newPathMappingButtonActionPerformed(null);
        }
    }

    private void enabledCheckBoxActionPerformed(ActionEvent evt) {
    }

    private int getTableSelectedRow() {
        return this.pathMappingTable.getSelectedRow();
    }

    private Object[][] getPathMappingsData() {
        Map<String, String> mappings = RequireJsPreferences.getMappings(this.project);
        int mappingSize = mappings.size();
        Object[][] paths = new Object[mappingSize + 1][2];
        int index = 0;
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            paths[index][0] = mapping.getKey();
            paths[index][1] = new LocalPathCell(mapping.getValue());
            ++index;
        }
        paths[mappingSize][0] = null;
        paths[mappingSize][1] = new LocalPathCell(DEFAULT_LOCAL_PATH);
        return paths;
    }

    private Map<String, String> getPathMappings() {
        TreeMap<String, String> mappings = new TreeMap<String, String>();
        for (int i = 0; i < this.pathMappingTableModel.getRowCount(); ++i) {
            String mapping = (String)this.pathMappingTableModel.getValueAt(i, 0);
            String localPath = ((LocalPathCell)this.pathMappingTableModel.getValueAt(i, 1)).getPath();
            if (mapping == null || mapping.isEmpty() || localPath == null || localPath.isEmpty()) continue;
            mappings.put(mapping, localPath);
        }
        return mappings;
    }

    private String findRelativePath(FileObject from, FileObject to) {
        String path = FileUtil.getRelativePath((FileObject)from, (FileObject)to);
        StringBuilder result = new StringBuilder();
        for (FileObject parent = from.getParent(); path == null && parent != null; parent = parent.getParent()) {
            result.append("../");
            path = FileUtil.getRelativePath((FileObject)parent, (FileObject)to);
        }
        if (path != null) {
            result.append(path);
        } else {
            result.append(to.getPath());
        }
        return result.toString();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private final class LocalPathCellMouseListener
    extends MouseAdapter {
        private final JTable table;

        public LocalPathCellMouseListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int col;
            Point p = new Point(e.getX(), e.getY());
            int row = this.table.rowAtPoint(p);
            Object value = this.table.getValueAt(row, col = this.table.columnAtPoint(p));
            if (value instanceof LocalPathCell) {
                FileObject projectDirectory;
                File newLocation;
                Rectangle cellRect = this.table.getCellRect(row, col, false);
                LocalPathCell localPathCell = (LocalPathCell)value;
                JButton button = localPathCell.getButton();
                if (e.getX() > cellRect.x + cellRect.width - button.getWidth() && (newLocation = this.browseAction(".", "Select somethings", false, FileUtil.toFile((FileObject)(projectDirectory = RequireJsPanel.this.project.getProjectDirectory())))) != null) {
                    localPathCell.setPath(RequireJsPanel.this.findRelativePath(projectDirectory, FileUtil.toFileObject((File)newLocation)));
                }
            }
        }

        private File browseAction(String dirKey, String title, boolean filesOnly, File workDir) {
            File selectedFile;
            FileChooserBuilder builder = new FileChooserBuilder(dirKey).setTitle(title);
            if (workDir != null) {
                builder.setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true);
            }
            if (filesOnly) {
                builder.setFilesOnly(true);
            }
            if ((selectedFile = builder.showOpenDialog()) != null) {
                return FileUtil.normalizeFile((File)selectedFile);
            }
            return null;
        }
    }

    private static final class LocalPathCellRenderer
    implements TableCellRenderer {
        private LocalPathCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            LocalPathCell localPathCell = (LocalPathCell)value;
            if (localPathCell == null) {
                localPathCell = new LocalPathCell(RequireJsPanel.DEFAULT_LOCAL_PATH);
            }
            if (isSelected) {
                localPathCell.setBgColor(table.getSelectionBackground());
                localPathCell.setFgColor(table.getSelectionForeground());
            } else {
                localPathCell.setBgColor(table.getBackground());
                localPathCell.setFgColor(table.getForeground());
            }
            return localPathCell;
        }
    }

    private static final class PathMappingTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 169356031075115831L;

        public PathMappingTableModel(String[] columnNames, Object[][] data) {
            super(data, columnNames);
        }

        public boolean isLastServerPathFilled() {
            int rowCount = this.getRowCount();
            if (rowCount == 0) {
                return true;
            }
            return StringUtils.hasText((String)this.getValueAt(rowCount - 1, 0));
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 1) {
                return LocalPathCell.class;
            }
            if (columnIndex == 0) {
                return String.class;
            }
            throw new IllegalStateException("Unhandled column index: " + columnIndex);
        }
    }
}

