/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsArray;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndexer;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DefineInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("define|requirejs|require");
    private static final String CODE_COMPLETION_THREAD_NAME = "Code Completion";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        block34: {
            FileObject fo;
            FunctionArgument modules;
            block32: {
                ArrayList<String> paths;
                JsFunction defFunc;
                block35: {
                    FunctionArgument fArg;
                    block33: {
                        fArg = null;
                        modules = null;
                        for (FunctionArgument arg : args) {
                            switch (arg.getKind()) {
                                case ANONYMOUS_OBJECT: 
                                case REFERENCE: {
                                    fArg = arg;
                                    break;
                                }
                                case ARRAY: {
                                    modules = arg;
                                    break;
                                }
                                case STRING: {
                                    if (args.size() != 1) break;
                                    modules = arg;
                                    break;
                                }
                            }
                        }
                        fo = globalObject.getFileObject();
                        if (fo == null) {
                            return;
                        }
                        if (fArg == null) break block32;
                        if (fArg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) break block33;
                        if (!RequireJsIndexer.Factory.isScannerThread() || !"define".equals(name)) break block34;
                        JsObject anonym = (JsObject)fArg.getValue();
                        RequireJsIndexer.addTypes(fo.toURI(), Collections.singletonList(factory.newType(anonym.getFullyQualifiedName(), anonym.getOffset(), true)));
                        break block34;
                    }
                    List fqn = (List)fArg.getValue();
                    JsObject posibleFunc = DefineInterceptor.findJsObjectByName(globalObject, fqn);
                    if (posibleFunc == null || !(posibleFunc instanceof JsFunction)) break block34;
                    defFunc = (JsFunction)posibleFunc;
                    Source source = Source.create((FileObject)fo);
                    paths = new ArrayList<String>();
                    if (modules != null) {
                        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)source.createSnapshot().getTokenHierarchy(), (int)modules.getOffset());
                        if (ts == null) {
                            return;
                        }
                        ts.move(modules.getOffset());
                        if (ts.moveNext()) {
                            Token token = ts.token();
                            int index = 0;
                            while (ts.moveNext() && token.id() != JsTokenId.BRACKET_RIGHT_BRACKET) {
                                token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END));
                                if (token.id() == JsTokenId.STRING) {
                                    while (index > paths.size()) {
                                        paths.add("");
                                    }
                                    paths.add(token.text().toString());
                                    continue;
                                }
                                if (token.id() != JsTokenId.OPERATOR_COMMA) continue;
                                ++index;
                            }
                        }
                    }
                    if (!this.saveToIndex()) break block35;
                    if (!"define".equals(name)) break block34;
                    Collection returnTypes = defFunc.getReturnTypes();
                    RequireJsIndexer.addTypes(fo.toURI(), returnTypes);
                    if (paths.isEmpty()) break block34;
                    HashSet<String> plugins = new HashSet<String>();
                    for (String path : paths) {
                        String plugin = FSCompletionUtils.containsPlugin(path) ? path.substring(0, path.length() - FSCompletionUtils.removePlugin(path).length() - 1) : "";
                        if (plugin.isEmpty() || plugins.contains(plugin)) continue;
                        plugins.add(plugin);
                    }
                    if (plugins.isEmpty()) break block34;
                    RequireJsIndexer.addUsedPlugings(fo.toURI(), plugins);
                    break block34;
                }
                if (modules == null || !(modules.getValue() instanceof JsArray)) break block34;
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project == null || !RequireJsPreferences.getBoolean(project, RequireJsPreferences.ENABLED).booleanValue()) {
                    return;
                }
                if (paths.isEmpty()) break block34;
                RequireJsIndex rIndex = null;
                try {
                    rIndex = RequireJsIndex.get(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (rIndex == null) break block34;
                Iterator paramIterator = defFunc.getParameters().iterator();
                for (String module : paths) {
                    FileObject fileObject = FSCompletionUtils.findMappedFileObject(module = FSCompletionUtils.removePlugin(module), fo);
                    if (fileObject != null) {
                        module = fileObject.getName();
                    }
                    Collection<? extends TypeUsage> exposedTypes = rIndex.getExposedTypes(module, factory);
                    if (!paramIterator.hasNext()) continue;
                    JsObject jsObject = (JsObject)paramIterator.next();
                    for (TypeUsage typeUsage : exposedTypes) {
                        jsObject.addAssignment(typeUsage, -1);
                    }
                }
                break block34;
            }
            if (modules != null && modules.getValue() instanceof String) {
                Source source = Source.create((FileObject)fo);
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project == null || !RequireJsPreferences.getBoolean(project, RequireJsPreferences.ENABLED).booleanValue()) {
                    return;
                }
                TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)source.createSnapshot().getTokenHierarchy(), (int)modules.getOffset());
                if (ts == null) {
                    return;
                }
                ts.move(modules.getOffset());
                if (ts.movePrevious()) {
                    Token token = ts.token();
                    token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.BRACKET_LEFT_PAREN));
                    if (token.id() == JsTokenId.IDENTIFIER && "require".equals(token.text().toString()) && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() == JsTokenId.OPERATOR_ASSIGNMENT && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT))).id() == JsTokenId.IDENTIFIER) {
                        FileObject fileObject;
                        RequireJsIndex rIndex = null;
                        try {
                            rIndex = RequireJsIndex.get(project);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        if (rIndex != null && (fileObject = FSCompletionUtils.findMappedFileObject(modules.getValue().toString(), fo)) != null) {
                            Collection<? extends TypeUsage> exposedTypes = rIndex.getExposedTypes(fileObject.getName(), factory);
                            JsObject object = null;
                            String objectName = token.text().toString();
                            for (DeclarationScope declarationScope = DefineInterceptor.getDeclarationScope(globalObject, modules.getOffset()); declarationScope != null && object == null; declarationScope = declarationScope.getParentScope()) {
                                object = ((JsObject)declarationScope).getProperty(objectName);
                            }
                            if (object != null) {
                                int nearOccurrenceEnd = -1;
                                for (Occurrence occurrence : object.getOccurrences()) {
                                    int occurrenceOffsetEnd = occurrence.getOffsetRange().getEnd();
                                    if (occurrenceOffsetEnd >= modules.getOffset() || occurrenceOffsetEnd <= nearOccurrenceEnd) continue;
                                    nearOccurrenceEnd = occurrenceOffsetEnd;
                                }
                                for (TypeUsage typeUsage : exposedTypes) {
                                    object.addAssignment(typeUsage, nearOccurrenceEnd > -1 ? nearOccurrenceEnd : modules.getOffset());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean saveToIndex() {
        return RequireJsIndexer.Factory.isScannerThread() && !CODE_COMPLETION_THREAD_NAME.equals(Thread.currentThread().getName());
    }

    public static JsObject findJsObjectByName(JsObject global, List<String> fqn) {
        JsObject result;
        JsObject property = result = global;
        for (String token : fqn) {
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(JsObject global, int offset) {
        DeclarationScope dScope = (DeclarationScope)global;
        DeclarationScope result = null;
        if (result == null && ((JsObject)dScope).getOffsetRange().containsInclusive(offset)) {
            result = dScope;
            boolean deep = true;
            block0: while (deep) {
                deep = false;
                for (DeclarationScope innerScope : result.getChildrenScopes()) {
                    if (!((JsObject)innerScope).getOffsetRange().containsInclusive(offset)) continue;
                    result = innerScope;
                    deep = true;
                    continue block0;
                }
            }
        }
        return result;
    }
}

