/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndexer;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;

public class ConfigInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("requirejs\\.config");

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public void intercept(String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (!RequireJsIndexer.Factory.isScannerThread()) {
            return;
        }
        FunctionArgument fArg = null;
        for (FunctionArgument farg : args) {
            if (farg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) continue;
            fArg = farg;
            break;
        }
        if (fArg != null && fArg.getValue() instanceof JsObject) {
            JsObject paths = ((JsObject)fArg.getValue()).getProperty("paths");
            JsObject baseUrl = ((JsObject)fArg.getValue()).getProperty("baseUrl");
            if (paths != null || baseUrl != null) {
                FileObject fo = globalObject.getFileObject();
                if (fo == null) {
                    return;
                }
                Source source = Source.create((FileObject)fo);
                TokenHierarchy th = source.createSnapshot().getTokenHierarchy();
                if (paths != null) {
                    Token token;
                    TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)paths.getOffset());
                    if (ts == null) {
                        return;
                    }
                    HashMap<String, String> mapping = new HashMap<String, String>();
                    for (JsObject path : paths.getProperties().values()) {
                        String alias = path.getName();
                        String target = null;
                        ts.move(path.getOffset());
                        if (ts.moveNext() && (token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON))).id() == JsTokenId.OPERATOR_COLON && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.OPERATOR_COLON))).id() == JsTokenId.STRING) {
                            target = token.text().toString();
                        }
                        if (target == null) continue;
                        mapping.put(alias, target);
                    }
                    if (!mapping.isEmpty()) {
                        RequireJsIndexer.addPathMapping(fo.toURI(), mapping);
                    }
                    if (baseUrl != null) {
                        ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)baseUrl.getOffset());
                        if (ts == null) {
                            return;
                        }
                        ts.move(baseUrl.getOffset());
                        String target = null;
                        if (ts.moveNext() && (token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON))).id() == JsTokenId.OPERATOR_COLON && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.OPERATOR_COLON))).id() == JsTokenId.STRING) {
                            target = token.text().toString();
                        }
                        if (target != null) {
                            RequireJsIndexer.addBasePath(fo.toURI(), target);
                        }
                    }
                }
            }
        }
    }
}

