/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.requirejs.ConfigOption;
import org.netbeans.modules.javascript2.requirejs.RequireJsDataProvider;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.EditorUtils;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.MappingCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.RequireJsCompletionItem;
import org.netbeans.modules.javascript2.requirejs.editor.SimpleHandle;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RequireJSCodeCompletion
implements CompletionProvider {
    /*
     * WARNING - void declaration
     */
    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        int offset;
        Snapshot snapshot = ccContext.getParserResult().getSnapshot();
        EditorUtils.CodeCompletionContext context = EditorUtils.findContext(snapshot, offset = snapshot.getEmbeddedOffset(ccContext.getCaretOffset()));
        if (context == EditorUtils.CodeCompletionContext.CONFIG_PROPERTY_NAME) {
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            Collection<String> names = RequireJsDataProvider.getDefault().getConfigurationOptions();
            for (String name : names) {
                if (!name.startsWith(prefix)) continue;
                ConfigOption option = null;
                try {
                    option = ConfigOption.getEnum(name);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (option != null) {
                    result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(option.getName(), option.getType(), offset - prefix.length()));
                    continue;
                }
                result.add(new RequireJsCompletionItem.PropertyNameCompletionItem(name, ConfigOption.OptionType.UNKNOWN, offset - prefix.length()));
            }
            return result;
        }
        if (context == EditorUtils.CodeCompletionContext.CONFIG_BASE_URL_VALUE || context == EditorUtils.CodeCompletionContext.CONFIG_PATHS_VALUE || context == EditorUtils.CodeCompletionContext.REQUIRE_MODULE) {
            TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)snapshot.getTokenHierarchy(), (int)offset);
            if (ts == null) {
                return Collections.emptyList();
            }
            ts.move(offset);
            String writtenPath = prefix;
            if (ts.moveNext() && (ts.token().id() == JsTokenId.STRING_END || ts.token().id() == JsTokenId.STRING)) {
                if (ts.token().id() == JsTokenId.STRING_END) {
                    ts.movePrevious();
                }
                if (ts.token().id() == JsTokenId.STRING) {
                    String text = ts.token().text().toString();
                    writtenPath = text.substring(0, offset - ts.offset());
                }
            }
            writtenPath = FSCompletionUtils.removePlugin(writtenPath);
            FileObject fo = snapshot.getSource().getFileObject();
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            RequireJsIndex rIndex = null;
            if (fo != null && EditorUtils.isFileReference(snapshot, offset)) {
                int index;
                ArrayList<Object> relativeTo = new ArrayList<Object>();
                Collection<String> usedFileInDefine = EditorUtils.getUsedFileInDefine(snapshot, offset);
                for (String path : usedFileInDefine) {
                    void var16_29;
                    FileObject fileObject = FSCompletionUtils.findMappedFileObject(path, fo);
                    String[] folders = path.split("/");
                    if (fileObject != null) {
                        void var16_26;
                        for (int i = 0; i < folders.length; ++i) {
                            FileObject fileObject2 = var16_26.getParent();
                        }
                        if (relativeTo.contains(var16_26)) continue;
                        relativeTo.add(var16_26);
                        continue;
                    }
                    if (project == null || folders.length != 1) continue;
                    FileObject fileObject3 = fo.getParent();
                    while (!var16_29.equals(project.getProjectDirectory())) {
                        Enumeration children = var16_29.getChildren(false);
                        while (children.hasMoreElements()) {
                            FileObject child = (FileObject)children.nextElement();
                            if (!child.getName().startsWith(folders[folders.length - 1]) || relativeTo.contains(var16_29)) continue;
                            relativeTo.add(var16_29);
                        }
                        FileObject fileObject4 = var16_29.getParent();
                    }
                }
                if (project != null) {
                    try {
                        rIndex = RequireJsIndex.get(project);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (relativeTo.isEmpty()) {
                    Collection<Object> basePaths = new ArrayList();
                    if (rIndex != null) {
                        basePaths = rIndex.getBasePaths();
                        relativeTo.add(fo.getParent());
                        if (!basePaths.isEmpty()) {
                            for (String string : basePaths) {
                                FileObject findFO = FSCompletionUtils.findFileObject(fo, string);
                                if (findFO == null) continue;
                                relativeTo.add(findFO);
                            }
                        }
                    }
                }
                ArrayList<CompletionProposal> result = new ArrayList();
                try {
                    result = FSCompletionUtils.computeRelativeItems(relativeTo, writtenPath, ccContext.getCaretOffset(), new FSCompletionUtils.JSIncludesFilter(fo));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                FileObject fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath, fo);
                String string = "";
                if (fromMapping == null && (index = writtenPath.lastIndexOf(47)) > -1) {
                    fromMapping = FSCompletionUtils.findMappedFileObject(writtenPath.substring(0, index), fo);
                    String string2 = writtenPath.substring(index + 1);
                }
                if (fromMapping != null) {
                    relativeTo.clear();
                    relativeTo.add(fromMapping);
                    try {
                        void var16_35;
                        List<CompletionProposal> newItems = FSCompletionUtils.computeRelativeItems(relativeTo, (String)var16_35, ccContext.getCaretOffset(), new FSCompletionUtils.JSIncludesFilter(fo));
                        for (CompletionProposal proposel : newItems) {
                            if (result.contains(proposel)) continue;
                            result.add(proposel);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                HashMap<String, String> mappings = new HashMap<String, String>();
                if (rIndex != null) {
                    mappings.putAll(rIndex.getPathMappings(writtenPath));
                }
                mappings.putAll(RequireJsPreferences.getMappings(project));
                for (String mapping : mappings.keySet()) {
                    if (!mapping.startsWith(writtenPath)) continue;
                    result.add(new MappingCompletionItem(mapping, FSCompletionUtils.findMappedFileObject(mapping, fo), ccContext.getCaretOffset() - writtenPath.length()));
                }
                if (rIndex != null && (writtenPath.isEmpty() || !writtenPath.contains("!") && !writtenPath.contains("/"))) {
                    Collection<String> usedPlugins = rIndex.getUsedPlugins();
                    for (String plugin : usedPlugins) {
                        if (!plugin.startsWith(prefix)) continue;
                        result.add(new RequireJsCompletionItem.PluginNameCompletionItem(plugin, ccContext.getCaretOffset() - prefix.length()));
                    }
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        FileObject fo;
        if (element != null && element instanceof FSCompletionItem.FSElementHandle && (fo = element.getFileObject()) != null) {
            return FSCompletionUtils.writeFilePathForDocWindow(fo);
        }
        if (element != null && element instanceof SimpleHandle.DocumentationHandle) {
            return ((SimpleHandle.DocumentationHandle)element).getDocumentation();
        }
        return null;
    }
}

