/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript2.requirejs.StringUtils;

public class RequireJsPreferences {
    private static final String DEFAULT_VALUE = "";
    private static final String MAPPINGS_SEPARATOR = "}{";
    private static final String MAPPINGS_PATH_SEPARATOR = " , ";
    public static final Property<Boolean> ENABLED = new Property<Boolean>("enabled"){

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    private static final Property<String> MAPPINGS = new Property<String>("mappings"){

        @Override
        public String getDefaultValue() {
            return RequireJsPreferences.DEFAULT_VALUE;
        }
    };

    public static Boolean getBoolean(Project project, Property<Boolean> property) {
        return Boolean.parseBoolean(RequireJsPreferences.get(project, property));
    }

    public static void putBoolean(Project project, Property<Boolean> property, boolean value) {
        RequireJsPreferences.put(project, property, Boolean.toString(value));
    }

    public static final Map<String, String> getMappings(Project project) {
        String storedMappings = RequireJsPreferences.get(project, MAPPINGS);
        if (storedMappings == null || storedMappings.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] mappings = storedMappings.split(Pattern.quote(MAPPINGS_SEPARATOR));
        TreeMap<String, String> result = new TreeMap<String, String>();
        String pattern = Pattern.quote(MAPPINGS_PATH_SEPARATOR);
        for (String mapping : mappings) {
            String[] parts = mapping.split(pattern);
            if (parts.length != 2) continue;
            if (parts[0].startsWith("{")) {
                parts[0] = parts[0].substring(1);
            }
            parts[0] = parts[0].trim();
            if (parts[1].endsWith("}")) {
                parts[1] = parts[1].substring(0, parts[1].length() - 1);
            }
            parts[1] = parts[1].trim();
            result.put(parts[0], parts[1]);
        }
        return result;
    }

    public static final void storeMappings(Project project, Map<String, String> mappings) {
        StringBuilder storedMappings = new StringBuilder();
        if (mappings.isEmpty()) {
            storedMappings.append(MAPPINGS.getDefaultValue());
        } else {
            storedMappings.append('{');
            for (Map.Entry<String, String> mapping : mappings.entrySet()) {
                if (storedMappings.length() > 1) {
                    storedMappings.append(MAPPINGS_SEPARATOR);
                }
                storedMappings.append(mapping.getKey().trim()).append(MAPPINGS_PATH_SEPARATOR).append(mapping.getValue().trim());
            }
            storedMappings.append('}');
        }
        RequireJsPreferences.put(project, MAPPINGS, storedMappings.toString());
    }

    public static String get(Project project, Property<? extends Object> property) {
        Preferences preferences = RequireJsPreferences.getPreferences(project);
        String value = preferences.get(property.getKey(), DEFAULT_VALUE);
        if (DEFAULT_VALUE.equals(value)) {
            Object defaultValue = property.getDefaultValue();
            if (defaultValue == null) {
                return null;
            }
            return defaultValue.toString();
        }
        if (!StringUtils.hasText(value)) {
            return null;
        }
        return value;
    }

    public static void put(Project project, Property<? extends Object> property, String value) {
        if (StringUtils.hasText(value) && !value.equals(property.getDefaultValue())) {
            RequireJsPreferences.getPreferences(project).put(property.getKey(), value);
        } else {
            RequireJsPreferences.getPreferences(project).remove(property.getKey());
        }
    }

    private static Preferences getPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, RequireJsPreferences.class, (boolean)true);
    }

    public static class Property<T> {
        private final String key;

        private Property(String key) {
            assert (key != null);
            this.key = key;
        }

        String getKey() {
            return this.key;
        }

        public T getDefaultValue() {
            return null;
        }
    }
}

