/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsConstraint
implements Serializable {
    private static final long serialVersionUID = 3762248660406450488L;
    private String arch;
    private String family;
    private String jre;
    private String name;
    private String version;

    public OsConstraint(String string, String string2, String string3, String string4, String string5) {
        this.family = string != null ? string.toLowerCase() : null;
        this.name = string2 != null ? string2.toLowerCase() : null;
        this.version = string3 != null ? string3.toLowerCase() : null;
        this.arch = string4 != null ? string4.toLowerCase() : null;
        this.jre = string5 != null ? string5.toLowerCase() : null;
    }

    public OsConstraint(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null);
    }

    public boolean matchCurrentSystem() {
        boolean bl = true;
        String string = System.getProperty("os.name").toLowerCase();
        if (this.arch != null && this.arch.length() != 0) {
            bl = System.getProperty("os.arch").toLowerCase().equals(this.arch);
        }
        if (bl && this.version != null && this.version.length() != 0) {
            bl = System.getProperty("os.version").toLowerCase().equals(this.version);
        }
        if (bl && this.name != null && this.name.length() != 0) {
            bl = string.equals(this.name);
        }
        if (bl && this.family != null) {
            if ("windows".equals(this.family)) {
                bl = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(this.family) || "osx".equals(this.family)) {
                bl = OsVersion.IS_OSX;
            } else if ("unix".equals(this.family)) {
                bl = OsVersion.IS_UNIX;
            }
        }
        if (bl && this.jre != null && this.jre.length() > 0) {
            bl = System.getProperty("java.version").toLowerCase().startsWith(this.jre);
        }
        return bl && (this.family != null || this.name != null || this.version != null || this.arch != null || this.jre != null);
    }

    public static List<OsConstraint> getOsList(IXMLElement iXMLElement) {
        ArrayList<OsConstraint> arrayList = new ArrayList<OsConstraint>();
        for (IXMLElement object2 : iXMLElement.getChildrenNamed("os")) {
            arrayList.add(new OsConstraint(object2.getAttribute("family", null), object2.getAttribute("name", null), object2.getAttribute("version", null), object2.getAttribute("arch", null), object2.getAttribute("jre", null)));
        }
        String string = iXMLElement.getAttribute("os");
        if (string != null && string.length() > 0) {
            arrayList.add(new OsConstraint(string, null, null, null, null));
        }
        return arrayList;
    }

    public static boolean oneMatchesCurrentSystem(List<OsConstraint> list) {
        if (list == null) {
            return true;
        }
        Iterator<OsConstraint> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        while (iterator.hasNext()) {
            OsConstraint osConstraint = iterator.next();
            Debug.trace("checking if os constraints " + osConstraint + " match current OS");
            if (!osConstraint.matchCurrentSystem()) continue;
            Debug.trace("matched current OS.");
            return true;
        }
        Debug.trace("no match with current OS!");
        return false;
    }

    public static boolean oneMatchesCurrentSystem(IXMLElement iXMLElement) {
        return OsConstraint.oneMatchesCurrentSystem(OsConstraint.getOsList(iXMLElement));
    }

    public void setFamily(String string) {
        this.family = string.toLowerCase();
    }

    public String getFamily() {
        return this.family;
    }

    public void setName(String string) {
        this.name = string.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String string) {
        this.version = string.toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String string) {
        this.arch = string.toLowerCase();
    }

    public String getArch() {
        return this.arch;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Os ");
        stringBuffer.append(" family ").append(this.family);
        stringBuffer.append(" name ").append(this.name);
        stringBuffer.append(" version ").append(this.version);
        stringBuffer.append(" arch ").append(this.arch);
        stringBuffer.append(" jre ").append(this.jre);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

