; ------------------------------------------------------------
;-  ShortEx - Shortcut on flash drive (with variable drive letter)
; ------------------------------------------------------------
; The idea is to rename the program to a string that will be
; interpreted as shortcut (where drive letter is not required)
; details see ShortEx.txt

CommandPath.s = ProgramFilename()
CommandFile.s = GetFilePart(CommandPath)            ; without path
Command.s = Left(CommandFile,Len(CommandFile)-4)    ; without ".exe"
CommandDir.s = GetPathPart(CommandPath)             ; incl drive letter
CommandDrive.s = Left(CommandDir,2)                 ; drive, colon

ProgName.s = StringField(Command,1," ")                ; delimited by space 
DirPath.s = Trim(Mid(Command,Len(ProgName)+1))         ; rest of command
ReplaceString(DirPath,"+","\",#PB_String_InPlace)      ; + to \
ReplaceString(DirPath,"'",Chr('"'),#PB_String_InPlace) ; ' to "

If Asc(DirPath) = '"'                                  ; beginning with quote
  delimiter.s = Chr('"') : DirPath = Mid(DirPath,2)    ; drop leading quote
Else 
  delimiter = " "
EndIf 
endpos = FindString(DirPath,delimiter,1)
If endpos                                           ; else no arguments, options
  Tail.s = Mid(DirPath,endpos+1)                    ; command tail 
  DirPath = Left(DirPath,endpos-1)                  ; cut path
  ReplaceString(Tail,"-","/",#PB_String_InPlace)    ; - to /
EndIf 

If DirPath 
  If Asc(DirPath) = '\'                             ; beginning with backslash?
    DirPath = CommandDrive + DirPath                ; insert drive only 
  Else 
    DirPath = CommandDir + DirPath                  ; insert command dir
  EndIf  
  If Right(DirPath,1) <> "\" : DirPath + "\" : EndIf 
  FilePath.s = DirPath + ProgName + ".exe"
  
  ShellExecute_(0,0,FilePath,Tail,DirPath,#SW_SHOW)
  ; the Purebasic command produces an avast! alert "Win32:Malware-gen"
  ; RunProgram(FilePath,Tail,DirPath) 
Else                                                ; avoiding recurrence
  MessageBox_(0,"Please rename; see ShortExe.txt","ShortExe",0)
EndIf 

End

; IDE Options = PureBasic 4.50 (Windows - x86)
; CursorPosition = 40
; FirstLine = 3
; UseIcon = right.ico
; Executable = ShortExe.exe
; CompileSourceDirectory