//Language: PHP in HTML with multicolor syntax
// Custom coloring for CSS, SCRIPT, TABLE, IMG, FORM tags

// states
State=snormal
State=sstring1
State=sstring2
State=scomment1
State=stagname
State=shtmltag
State=shtmlvalue
State=shtmlCSS
State=shtmlCSSval
State=shtmlJS
State=shtmlJSval
State=shtmlTB
State=shtmlTBval
State=shtmlIMG
State=shtmlIMGval
State=shtmlFO
State=shtmlFOval
State=shtmlASP
State=shtmlPHP
State=sdoctype
State=sdoctypeval
State=sxmlinstr
State=sxmlinstrval

// states - php
State=sphpstring1
State=sphpstring2
State=sphpstring3
State=sphpcomment1
State=sphpcomment2
State=sphpcomment3
State=sphpvar

// states - css
State=scssnormal
State=scssstring1
State=scssstring2
State=scsscomment1
State=scsscomment2
State=scsscomment3
State=scsscomment4
State=scsscomment5
State=scsscomment6
State=scssstyle
State=scssvalue
State=scssimport
state=scssmedia
State=scssurl


// states - js
State=sjsnormal
State=sjsstring1
State=sjsstring2
State=sjscomment1
State=sjscomment2

// tokens
Token=tnone
Token=tstring
Token=tcomment
Token=tident
Token=tresword
Token=turl
Token=twhitespace
Token=tsymbol
Token=thtmlstyle
Token=thtmlscript
Token=thtmltable {HTML Table}
Token=thtmlimage {HTML Image}
Token=thtmlform {HTML Form}
Token=thtmlasp
Token=tentity
Token=tunknown
Token=tdoctype
Token=tXMLinstr

// tokens - php
Token=tphpident
Token=tphpinteger
Token=tphpfloat
Token=tphpstring
Token=tphpcomment
Token=tphpresword
Token=tphpvar
Token=tphpsymbol
Token=tphptag

// tokens - css
Token=tcssstring
Token=tcsscomment
Token=tcssinteger
Token=tcssfloat
Token=tcssresword
Token=tcssbracket
Token=tcssselector
Token=tcssproperty
Token=tcssvalue
Token=tcsssymbol
Token=tcssimport
Token=tcssmedia

// tokens - js
Token=tjsstring
Token=tjscomment
Token=tjsident
Token=tjsinteger
Token=tjsfloat
Token=tjsresword
Token=tjssymbol

//delims
Delimiters=;.,:'"{}[]()<>?!@#$%^&*-+=|\/


//Common
snormal <                          stagname    tsymbol
stagname [a-z_A-Z][a-z_A-Z0-9]*    shtmltag    tunknown
shtmltag [^\>^\'^\"^#32^\=]*       shtmltag    tident
stagname /                         stagname    tsymbol
shtmltag /                         shtmltag    tsymbol
shtmltag =                         shtmlvalue  tsymbol
shtmlvalue [^\>^#32^\=]*           shtmltag    tstring
shtmlvalue >                       snormal     tsymbol
stagname >                         snormal     tsymbol
shtmltag >                         snormal     tsymbol


//white space
snormal #32*                      snormal   twhitespace
shtmltag #32*                     shtmltag  tsymbol


//strings
shtmltag   \'                     sstring1   tstring
shtmlvalue \'                     sstring1   tstring
sstring1   [^\'^<]*               sstring1   tstring
sstring1   <[^?]                  sstring1   tstring
sstring1   \'                     shtmltag   tstring
sstring1   \'\'                   sstring1   tstring
sstring1   \\                     sstring1   tstring

shtmlvalue  \"                    sstring2   tstring
shtmltag    \"                    sstring2   tstring
sstring2   [^\"^<]*               sstring2   tstring
sstring2   <[^?]                  sstring2   tstring
sstring2   \"                     shtmltag   tstring
sstring2   \"\"                   sstring2   tstring
sstring2   \\                     sstring2   tstring


// table
snormal <table                    shtmlTB     thtmltable
snormal <td                       shtmlTB     thtmltable
snormal <tr                       shtmlTB     thtmltable
snormal <th                       shtmlTB     thtmltable
snormal <colgroup                 shtmlTB     thtmltable
snormal </table>                  snormal     thtmltable
snormal </td>                     snormal     thtmltable
snormal </tr>                     snormal     thtmltable
snormal </th>                     snormal     thtmltable
snormal </colgroup>               snormal     thtmltable

shtmlTB [^>^\"^<]*                shtmlTB     thtmltable
shtmlTB <[^?]                     shtmlTB     thtmltable
shtmlTB >                         snormal     thtmltable

shtmlTB  \"                       shtmlTBval   thtmltable
shtmlTBval  [^\"^<]*              shtmlTBval   thtmltable
shtmlTBval  <[^?]                 shtmlTBval   thtmltable
shtmlTBval  \"                    shtmlTB      thtmltable

// image
snormal <img                      shtmlIMG     thtmlimage

shtmlIMG [^>^\"^<]*               shtmlIMG     thtmlimage
shtmlIMG <[^?]                    shtmlIMG     thtmlimage
shtmlIMG >                        snormal      thtmlimage

shtmlIMG  \"                      shtmlIMGval   thtmlimage
shtmlIMGval  [^\"^<]*             shtmlIMGval   thtmlimage
shtmlIMGval <[^?]                 shtmlIMGval   thtmlimage
shtmlIMGval  \"                   shtmlIMG      thtmlimage

// form
snormal <form                    shtmlFO     thtmlform
snormal <input                   shtmlFO     thtmlform
snormal </form>                  snormal     thtmlform

shtmlFO [^>^\"^<]*               shtmlFO     thtmlform
shtmlFO <[^?]                    shtmlFO     thtmlform
shtmlFO >                        snormal     thtmlform

shtmlFO  \"                      shtmlFOval   thtmlform
shtmlFOval  [^\"^<]*             shtmlFOval   thtmlform
shtmlFOval  <[^?]                shtmlFOval   thtmlform
shtmlFOval  \"                   shtmlFO      thtmlform


// comments
snormal   <\!--                scomment1 tcomment
scomment1 [^\-]*               scomment1 tcomment
scomment1 [\-]*[^>]            scomment1 tcomment
scomment1  [\-]*>              snormal   tcomment

// ASP
snormal    <\%                 shtmlasp  thtmlasp
shtmlasp [^\%]*                shtmlasp  thtmlasp
shtmlasp \%[^>]                shtmlasp  thtmlasp
shtmlasp [\%]*>                snormal   thtmlasp

// DOCTYPE

snormal <\!DOCTYPE                 sdoctype    tdoctype
sdoctype [^>^\"]*                  sdoctype    tdoctype
sdoctype >                         snormal     tdoctype

sdoctype  \"                       sdoctypeval  tdoctype
sdoctypeval  [^\"]*                sdoctypeval  tdoctype
sdoctypeval  \"                    sdoctype     tdoctype

// XML

snormal <?xml                       sxmlinstr    tXMLinstr
sxmlinstr [^>^\"]*                  sxmlinstr    tXMLinstr
sxmlinstr >                         snormal      tXMLinstr

sxmlinstr  \"                       sxmlinstrval  tXMLinstr
sxmlinstrval  [^\"]*                sxmlinstrval  tXMLinstr
sxmlinstrval  \"                    sxmlinstr     tXMLinstr

//reswords
//@@@HTM
stagname  'a'           shtmltag  tresword
stagname  'abbr'        shtmltag  tresword
stagname  'acronym'     shtmltag  tresword
stagname  'address'     shtmltag  tresword
stagname  'applet'      shtmltag  tresword
stagname  'area'        shtmltag  tresword
stagname  'b'           shtmltag  tresword
stagname  'base'        shtmltag  tresword
stagname  'basefont'    shtmltag  tresword
stagname  'bdo'         shtmltag  tresword
stagname  'big'         shtmltag  tresword
stagname  'blockquote'  shtmltag  tresword
stagname  'body'        shtmltag  tresword
stagname  'br'          shtmltag  tresword
stagname  'button'      shtmltag  tresword
stagname  'caption'     shtmltag  tresword
stagname  'center'      shtmltag  tresword
stagname  'cite'        shtmltag  tresword
stagname  'code'        shtmltag  tresword
stagname  'col'         shtmltag  tresword
stagname  'colgroup'    shtmltag  tresword
stagname  'dd'          shtmltag  tresword
stagname  'del'         shtmltag  tresword
stagname  'dfn'         shtmltag  tresword
stagname  'dir'         shtmltag  tresword
stagname  'div'         shtmltag  tresword
stagname  'dl'          shtmltag  tresword
stagname  'dt'          shtmltag  tresword
stagname  'em'          shtmltag  tresword
stagname  'fieldset'    shtmltag  tresword
stagname  'font'        shtmltag  tresword
stagname  'form'        shtmltag  tresword
stagname  'frame'       shtmltag  tresword
stagname  'frameset'    shtmltag  tresword
stagname  'h1'          shtmltag  tresword
stagname  'h2'          shtmltag  tresword
stagname  'h3'          shtmltag  tresword
stagname  'h4'          shtmltag  tresword
stagname  'h5'          shtmltag  tresword
stagname  'h6'          shtmltag  tresword
stagname  'head'        shtmltag  tresword
stagname  'hr'          shtmltag  tresword
stagname  'html'        shtmltag  tresword
stagname  'i'           shtmltag  tresword
stagname  'iframe'      shtmltag  tresword
stagname  'img'         shtmltag  tresword
stagname  'input'       shtmltag  tresword
stagname  'ins'         shtmltag  tresword
stagname  'isindex'     shtmltag  tresword
stagname  'kbd'         shtmltag  tresword
stagname  'label'       shtmltag  tresword
stagname  'legend'      shtmltag  tresword
stagname  'li'          shtmltag  tresword
stagname  'link'        shtmltag  tresword
stagname  'map'         shtmltag  tresword
stagname  'menu'        shtmltag  tresword
stagname  'meta'        shtmltag  tresword
stagname  'noframes'    shtmltag  tresword
stagname  'noscript'    shtmltag  tresword
stagname  'object'      shtmltag  tresword
stagname  'ol'          shtmltag  tresword
stagname  'optgroup'    shtmltag  tresword
stagname  'option'      shtmltag  tresword
stagname  'p'           shtmltag  tresword
stagname  'param'       shtmltag  tresword
stagname  'pre'         shtmltag  tresword
stagname  'q'           shtmltag  tresword
stagname  's'           shtmltag  tresword
stagname  'samp'        shtmltag  tresword
stagname  'script'      shtmltag  tresword
stagname  'select'      shtmltag  tresword
stagname  'small'       shtmltag  tresword
stagname  'span'        shtmltag  tresword
stagname  'strike'      shtmltag  tresword
stagname  'strong'      shtmltag  tresword
stagname  'style'       shtmltag  tresword
stagname  'sub'         shtmltag  tresword
stagname  'sup'         shtmltag  tresword
stagname  'table'       shtmltag  tresword
stagname  'tbody'       shtmltag  tresword
stagname  'td'          shtmltag  tresword
stagname  'textarea'    shtmltag  tresword
stagname  'tfoot'       shtmltag  tresword
stagname  'th'          shtmltag  tresword
stagname  'thead'       shtmltag  tresword
stagname  'title'       shtmltag  tresword
stagname  'tr'          shtmltag  tresword
stagname  'tt'          shtmltag  tresword
stagname  'u'           shtmltag  tresword
stagname  'ul'          shtmltag  tresword
stagname  'var'         shtmltag  tresword
//HTM@@@

// non HTML 4.01 reswords
stagname  'marquee'     shtmltag  tresword

// entities
snormal  &lsquo;    snormal  tentity
snormal  &rsquo;    snormal  tentity
snormal  &sbquo;    snormal  tentity
snormal  &ldquo;    snormal  tentity
snormal  &rdquo;    snormal  tentity
snormal  &bdquo;    snormal  tentity
snormal  &dagger;   snormal  tentity
snormal  &Dagger;   snormal  tentity
snormal  &permil;   snormal  tentity
snormal  &lsaquo;   snormal  tentity
snormal  &rsaquo;   snormal  tentity
snormal  &spades;   snormal  tentity
snormal  &clubs;    snormal  tentity
snormal  &hearts;   snormal  tentity
snormal  &diams;    snormal  tentity
snormal  &oline;    snormal  tentity
snormal  &larr;     snormal  tentity 
snormal  &uarr;     snormal  tentity 
snormal  &rarr;     snormal  tentity 
snormal  &darr;     snormal  tentity 
snormal  &trade;    snormal  tentity
snormal  &quot;     snormal  tentity 
snormal  &amp;      snormal  tentity  
snormal  &frasl;    snormal  tentity
snormal  &lt;       snormal  tentity
snormal  &ndash;    snormal  tentity
snormal  &mdash;    snormal  tentity
snormal  &nbsp;     snormal  tentity 
snormal  &iexcl;    snormal  tentity
snormal  &cent;     snormal  tentity 
snormal  &pound;    snormal  tentity
snormal  &curren;   snormal  tentity
snormal  &yen;      snormal  tentity  
snormal  &brvbar;   snormal  tentity
snormal  &brkbar;   snormal  tentity
snormal  &sect;     snormal  tentity 
snormal  &uml;      snormal  tentity  
snormal  &die;      snormal  tentity  
snormal  &copy;     snormal  tentity 
snormal  &ordf;     snormal  tentity 
snormal  &laquo;    snormal  tentity
snormal  &not;      snormal  tentity  
snormal  &shy;      snormal  tentity  
snormal  &reg;      snormal  tentity  
snormal  &macr;     snormal  tentity 
snormal  &hibar;    snormal  tentity
snormal  &deg;      snormal  tentity  
snormal  &plusmn;   snormal  tentity
snormal  &sup2;     snormal  tentity 
snormal  &sup3;     snormal  tentity 
snormal  &acute;    snormal  tentity
snormal  &micro;    snormal  tentity
snormal  &para;     snormal  tentity 
snormal  &middot;   snormal  tentity
snormal  &cedil;    snormal  tentity
snormal  &sup1;     snormal  tentity 
snormal  &ordm;     snormal  tentity 
snormal  &raquo;    snormal  tentity
snormal  &frac14;   snormal  tentity
snormal  &frac12;   snormal  tentity
snormal  &frac34;   snormal  tentity
snormal  &iquest;   snormal  tentity
snormal  &Agrave;   snormal  tentity
snormal  &Aacute;   snormal  tentity
snormal  &Acirc;    snormal  tentity
snormal  &Atilde;   snormal  tentity
snormal  &Auml;     snormal  tentity 
snormal  &Aring;    snormal  tentity
snormal  &AElig;    snormal  tentity
snormal  &Ccedil;   snormal  tentity
snormal  &Egrave;   snormal  tentity
snormal  &Eacute;   snormal  tentity
snormal  &Ecirc;    snormal  tentity
snormal  &Euml;     snormal  tentity 
snormal  &Igrave;   snormal  tentity
snormal  &Iacute;   snormal  tentity
snormal  &Icirc;    snormal  tentity
snormal  &Iuml;     snormal  tentity 
snormal  &ETH;      snormal  tentity  
snormal  &Ntilde;   snormal  tentity
snormal  &Ograve;   snormal  tentity
snormal  &Oacute;   snormal  tentity
snormal  &Ocirc;    snormal  tentity
snormal  &Otilde;   snormal  tentity
snormal  &Ouml;     snormal  tentity 
snormal  &times;    snormal  tentity
snormal  &Oslash;   snormal  tentity
snormal  &Ugrave;   snormal  tentity
snormal  &Uacute;   snormal  tentity
snormal  &Ucirc;    snormal  tentity
snormal  &Uuml;     snormal  tentity 
snormal  &Yacute;   snormal  tentity
snormal  &THORN;    snormal  tentity
snormal  &szlig;    snormal  tentity
snormal  &agrave;   snormal  tentity
snormal  &aacute;   snormal  tentity
snormal  &acirc;    snormal  tentity
snormal  &atilde;   snormal  tentity
snormal  &auml;     snormal  tentity 
snormal  &aring;    snormal  tentity
snormal  &aelig;    snormal  tentity
snormal  &ccedil;   snormal  tentity
snormal  &egrave;   snormal  tentity
snormal  &eacute;   snormal  tentity
snormal  &ecirc;    snormal  tentity
snormal  &euml;     snormal  tentity 
snormal  &igrave;   snormal  tentity
snormal  &iacute;   snormal  tentity
snormal  &icirc;    snormal  tentity
snormal  &iuml;     snormal  tentity 
snormal  &eth;      snormal  tentity  
snormal  &ntilde;   snormal  tentity
snormal  &ograve;   snormal  tentity
snormal  &oacute;   snormal  tentity
snormal  &ocirc;    snormal  tentity
snormal  &otilde;   snormal  tentity
snormal  &ouml;     snormal  tentity 
snormal  &divide;   snormal  tentity
snormal  &oslash;   snormal  tentity
snormal  &ugrave;   snormal  tentity
snormal  &uacute;   snormal  tentity
snormal  &ucirc;    snormal  tentity
snormal  &uuml;     snormal  tentity 
snormal  &yacute;   snormal  tentity
snormal  &thorn;    snormal  tentity
snormal  &yuml;     snormal  tentity 
snormal  &gt;       snormal  tentity
snormal  &euro;     snormal  tentity
snormal  &hellip;     snormal  tentity
snormal  &\#[0-9]*;  snormal  tentity

// PHP -------------------------------------------------------------------------

shtmlTB  <?                          shtmlPHP   tphptag    SaveState
shtmlTB  <?php                       shtmlPHP   tphptag    SaveState
shtmlTBval  <?                       shtmlPHP   tphptag    SaveState
shtmlTBval  <?php                    shtmlPHP   tphptag    SaveState
shtmlIMG  <?                         shtmlPHP   tphptag    SaveState
shtmlIMG  <?php                      shtmlPHP   tphptag    SaveState
shtmlIMGval <?                       shtmlPHP   tphptag    SaveState
shtmlIMGval <?php                    shtmlPHP   tphptag    SaveState
shtmlFO  <?                          shtmlPHP   tphptag    SaveState
shtmlFO  <?php                       shtmlPHP   tphptag    SaveState
shtmlFOval  <?                       shtmlPHP   tphptag    SaveState
shtmlFOval  <?php                    shtmlPHP   tphptag    SaveState


snormal  <?[^x]                      shtmlPHP   tphptag    SaveState
snormal  <?php                       shtmlPHP   tphptag    SaveState
shtmlPHP ?>                          snormal    tphptag    LoadState

shtmltag  <?php                      shtmlPHP   tphptag    SaveState
shtmltag  <?                         shtmlPHP   tphptag    SaveState
stagname  <?                         shtmlPHP   tphptag    SaveState
stagname  <?php                      shtmlPHP   tphptag    SaveState
shtmlvalue  <?                       shtmlPHP   tphptag    SaveState
shtmlvalue  <?php                    shtmlPHP   tphptag    SaveState

sstring1  <?                         shtmlPHP   tphptag    SaveState
sstring2  <?                         shtmlPHP   tphptag    SaveState

// PHP -------------------------------------------------------------------------

// reswords

shtmlPHP '__CLASS__ '    shtmlPHP tphpresword
shtmlPHP '__FILE__'      shtmlPHP tphpresword
shtmlPHP '__FUNCTION__'  shtmlPHP tphpresword
shtmlPHP '__LINE__'      shtmlPHP tphpresword
shtmlPHP '__METHOD__'    shtmlPHP tphpresword
shtmlPHP 'abstract'     shtmlPHP tphpresword
shtmlPHP 'and'          shtmlPHP tphpresword
shtmlPHP 'as'           shtmlPHP tphpresword
shtmlPHP 'break'        shtmlPHP tphpresword
shtmlPHP 'case'         shtmlPHP tphpresword
shtmlPHP 'catch'        shtmlPHP tphpresword
shtmlPHP 'cfunction'    shtmlPHP tphpresword
shtmlPHP 'class'        shtmlPHP tphpresword
shtmlPHP 'clone'        shtmlPHP tphpresword
shtmlPHP 'const'        shtmlPHP tphpresword
shtmlPHP 'continue'     shtmlPHP tphpresword
shtmlPHP 'default'      shtmlPHP tphpresword
shtmlPHP 'die'          shtmlPHP tphpresword
shtmlPHP 'do'           shtmlPHP tphpresword
shtmlPHP 'echo'         shtmlPHP tphpresword
shtmlPHP 'else'         shtmlPHP tphpresword
shtmlPHP 'elseif'       shtmlPHP tphpresword
shtmlPHP 'enddeclare'   shtmlPHP tphpresword
shtmlPHP 'endfor'       shtmlPHP tphpresword
shtmlPHP 'endforeach'   shtmlPHP tphpresword
shtmlPHP 'endif'        shtmlPHP tphpresword
shtmlPHP 'endswitch'    shtmlPHP tphpresword
shtmlPHP 'endwhile'     shtmlPHP tphpresword
shtmlPHP 'exception'    shtmlPHP tphpresword
shtmlPHP 'exit'         shtmlPHP tphpresword
shtmlPHP 'extends'      shtmlPHP tphpresword
shtmlPHP 'final'        shtmlPHP tphpresword
shtmlPHP 'for'          shtmlPHP tphpresword
shtmlPHP 'foreach'      shtmlPHP tphpresword
shtmlPHP 'function'     shtmlPHP tphpresword
shtmlPHP 'global'       shtmlPHP tphpresword
shtmlPHP 'if'           shtmlPHP tphpresword
shtmlPHP 'int'          shtmlPHP tphpresword
shtmlPHP 'implements'   shtmlPHP tphpresword
shtmlPHP 'include'      shtmlPHP tphpresword
shtmlPHP 'include_once' shtmlPHP tphpresword
shtmlPHP 'interface'    shtmlPHP tphpresword
shtmlPHP 'new'          shtmlPHP tphpresword
shtmlPHP 'old_function' shtmlPHP tphpresword
shtmlPHP 'or'           shtmlPHP tphpresword
shtmlPHP 'php_user_filter' shtmlPHP tphpresword
shtmlPHP 'print'        shtmlPHP tphpresword
shtmlPHP 'private'      shtmlPHP tphpresword
shtmlPHP 'protected'    shtmlPHP tphpresword
shtmlPHP 'public'       shtmlPHP tphpresword
shtmlPHP 'require'      shtmlPHP tphpresword
shtmlPHP 'require_once' shtmlPHP tphpresword
shtmlPHP 'return'       shtmlPHP tphpresword
shtmlPHP 'static'       shtmlPHP tphpresword
shtmlPHP 'switch'       shtmlPHP tphpresword
shtmlPHP 'throw'        shtmlPHP tphpresword
shtmlPHP 'try'          shtmlPHP tphpresword
shtmlPHP 'use'          shtmlPHP tphpresword
shtmlPHP 'var'          shtmlPHP tphpresword
shtmlPHP 'while'        shtmlPHP tphpresword
shtmlPHP 'xor'          shtmlPHP tphpresword

// These are reserved too but act just like regular functions, thus we skip
//shtmlPHP 'array'        shtmlPHP tphpresword
//shtmlPHP 'empty'        shtmlPHP tphpresword
//shtmlPHP 'eval'         shtmlPHP tphpresword
//shtmlPHP 'isset'        shtmlPHP tphpresword
//shtmlPHP 'list'         shtmlPHP tphpresword
//shtmlPHP 'unset'        shtmlPHP tphpresword

// idents
shtmlPHP   [a-z_A-Z][a-z_A-Z0-9]* shtmlPHP   tphpident

// variables
shtmlPHP \$                       sphpvar   tphpvar
sphpvar [a-z_A-Z][a-z_A-Z0-9]*    shtmlPHP  tphpvar
sphpvar [^a-z_A-Z]                shtmlPHP  tphpsymbol

// numbers
shtmlPHP [0-9][0-9]*              shtmlPHP  tphpinteger
shtmlPHP 0x[0-9A-F]+              shtmlPHP  tphpinteger
shtmlPHP [1-9][0-9]*\.[0-9]*                     shtmlPHP  tphpfloat
shtmlPHP [1-9][0-9]*{\.[0-9]+}|e{[\+\-]}|[0-9]+  shtmlPHP  tphpfloat

//symbols  (must be before heredoc)
shtmlPHP  [<>()\[\]\{\}\.,=;&|]     shtmlPHP      tphpsymbol

//strings
shtmlPHP  \'                     sphpstring1   tphpstring
sphpstring1  [^\']*              sphpstring1   tphpstring
sphpstring1  \'                  shtmlPHP      tphpstring
sphpstring1  \'\'                sphpstring1   tphpstring
sphpstring1   \\\\               sphpstring1   tphpstring
sphpstring1   \\\'               sphpstring1   tphpstring
sphpstring1   \\[^\\]            sphpstring1   tphpstring

shtmlPHP  \"                     sphpstring2   tphpstring
sphpstring2  [^\"]*              sphpstring2   tphpstring
sphpstring2  \"                  shtmlPHP      tphpstring
sphpstring2  \"\"                sphpstring2   tphpstring
sphpstring2   \\\\               sphpstring2   tphpstring
sphpstring2   \\\"               sphpstring2   tphpstring
sphpstring2   \\[^\\]            sphpstring2   tphpstring

//heredoc
shtmlPHP <<<EO[A-Z]$             sphpstring3   tphpstring
sphpstring3  .*$                 sphpstring3   tphpstring
sphpstring3  ^EO[A-Z];$          shtmlPHP      tphpstring
sphpstring3  ^EO[A-Z]$           shtmlPHP      tphpstring

//comments
shtmlPHP   //                      sphpcomment1  tphpcomment
sphpcomment1  [#1-#255]*           shtmlPHP      tphpcomment
sphpcomment1 $                     shtmlPHP      tphpcomment

shtmlPHP   \#                      sphpcomment2  tphpcomment
sphpcomment2  [#1-#255]*           shtmlPHP      tphpcomment
sphpcomment2 $                     shtmlPHP      tphpcomment

shtmlPHP   /\*                     sphpcomment3  tphpcomment
sphpcomment3  [^\*]*               sphpcomment3  tphpcomment
sphpcomment3  \*[^/]               sphpcomment3  tphpcomment
sphpcomment3  [\*]*/               shtmlPHP      tphpcomment

//white space
shtmlPHP  #32*                     shtmlPHP      tphpsymbol

// CSS -------------------------------------------------------------------------

// switch

snormal <style                     shtmlCSS    thtmlstyle
shtmlCSS [^>^\"]*                  shtmlCSS    thtmlstyle
shtmlCSS >                         scssnormal  thtmlstyle
scssnormal </style>                snormal     thtmlstyle
scssstyle </style>                 snormal     thtmlstyle
scssvalue </style>                 snormal     thtmlstyle
scsscomment1 </style>              snormal     thtmlstyle
scsscomment2 </style>              snormal     thtmlstyle
scsscomment3 </style>              snormal     thtmlstyle
scsscomment4 </style>              snormal     thtmlstyle
scsscomment5 </style>              snormal     thtmlstyle
scsscomment6 </style>              snormal     thtmlstyle
scssstring1 </style>               snormal     thtmlstyle
scssstring2 </style>               snormal     thtmlstyle

shtmlCSS  \"                       shtmlCSSval   thtmlstyle
shtmlCSSval   [^\"]*               shtmlCSSval   thtmlstyle
shtmlCSSval   \"                   shtmlCSS      thtmlstyle

// idents

scssnormal  [a-z_A-Z][a-z_A-Z0-9]*    scssnormal  tcssselector
scssstyle   [A-Z_a-z][0-9A-Z_a-z\-]*  scssstyle   tcssproperty
scssvalue   [A-Z_a-z][0-9A-Z_a-z\-]*    scssvalue   tcssvalue

//white space
scssnormal #32*                     scssnormal  tcsssymbol
scssstyle #32*                      scssstyle   tcsssymbol
scssvalue #32*                      scssvalue   tcsssymbol

//imports
scssnormal @import                  scssimport  tcssimport
scssimport [^;]*                    scssimport  tcssimport
scssimport $                        scssnormal  tcssimport
scssimport ;                        scssnormal  tcssimport

//media
scssnormal @media                   scssmedia   tcssmedia
scssmedia [^\{]*                    scssmedia   tcssmedia
scssmedia \{                        scssnormal  tcssmedia
scssnormal \}                       scssnormal  tcssmedia

//Common
scssnormal \{                       scssstyle   tcssbracket
scssstyle  \}                       scssnormal  tcssbracket
scssvalue  \}                       scssnormal  tcssbracket
scssstyle  \:                       scssvalue   tcsssymbol
scssvalue  \;                       scssstyle   tcsssymbol

// urls
scssvalue url(                      scssurl    tcssvalue
scssurl )                           scssvalue  tcssvalue
scssurl [^)]*                       scssurl    tcssvalue

//  symbols
scssvalue  [\,\(\)\-]                 scssvalue  tcsssymbol
scssstyle  [^A-Z_a-z^\}^\:^#32^#9]*   scssstyle   tcsssymbol
scssnormal [\:\-\+\>\*\.]           scssnormal tcssselector
scssnormal \#                       scssnormal tcssselector

// reswords
//@@@CSS
scssstyle 'azimuth' scssstyle tcssresword
scssstyle 'background' scssstyle tcssresword
scssstyle 'background-attachment' scssstyle tcssresword
scssstyle 'background-color' scssstyle tcssresword
scssstyle 'background-image' scssstyle tcssresword
scssstyle 'background-position' scssstyle tcssresword
scssstyle 'background-repeat' scssstyle tcssresword
scssstyle 'border' scssstyle tcssresword
scssstyle 'border-bottom' scssstyle tcssresword
scssstyle 'border-bottom-color' scssstyle tcssresword
scssstyle 'border-bottom-style' scssstyle tcssresword
scssstyle 'border-bottom-width' scssstyle tcssresword
scssstyle 'border-collapse' scssstyle tcssresword
scssstyle 'border-color' scssstyle tcssresword
scssstyle 'border-left' scssstyle tcssresword
scssstyle 'border-left-color' scssstyle tcssresword
scssstyle 'border-left-style' scssstyle tcssresword
scssstyle 'border-left-width' scssstyle tcssresword
scssstyle 'border-right' scssstyle tcssresword
scssstyle 'border-right-color' scssstyle tcssresword
scssstyle 'border-right-style' scssstyle tcssresword
scssstyle 'border-right-width' scssstyle tcssresword
scssstyle 'border-spacing' scssstyle tcssresword
scssstyle 'border-style' scssstyle tcssresword
scssstyle 'border-top' scssstyle tcssresword
scssstyle 'border-top-color' scssstyle tcssresword
scssstyle 'border-top-style' scssstyle tcssresword
scssstyle 'border-top-width' scssstyle tcssresword
scssstyle 'border-width' scssstyle tcssresword
scssstyle 'bottom' scssstyle tcssresword
scssstyle 'caption-side' scssstyle tcssresword
scssstyle 'clear' scssstyle tcssresword
scssstyle 'clip' scssstyle tcssresword
scssstyle 'color' scssstyle tcssresword
scssstyle 'content' scssstyle tcssresword
scssstyle 'counter-increment' scssstyle tcssresword
scssstyle 'counter-reset' scssstyle tcssresword
scssstyle 'cue' scssstyle tcssresword
scssstyle 'cue-after' scssstyle tcssresword
scssstyle 'cue-before' scssstyle tcssresword
scssstyle 'cursor' scssstyle tcssresword
scssstyle 'direction' scssstyle tcssresword
scssstyle 'display' scssstyle tcssresword
scssstyle 'elevation' scssstyle tcssresword
scssstyle 'empty-cells' scssstyle tcssresword
scssstyle 'float' scssstyle tcssresword
scssstyle 'font' scssstyle tcssresword
scssstyle 'font-family' scssstyle tcssresword
scssstyle 'font-size' scssstyle tcssresword
scssstyle 'font-size-adjust' scssstyle tcssresword
scssstyle 'font-stretch' scssstyle tcssresword
scssstyle 'font-style' scssstyle tcssresword
scssstyle 'font-variant' scssstyle tcssresword
scssstyle 'font-weight' scssstyle tcssresword
scssstyle 'height' scssstyle tcssresword
scssstyle 'left' scssstyle tcssresword
scssstyle 'letter-spacing' scssstyle tcssresword
scssstyle 'line-height' scssstyle tcssresword
scssstyle 'list-style' scssstyle tcssresword
scssstyle 'list-style-image' scssstyle tcssresword
scssstyle 'list-style-position' scssstyle tcssresword
scssstyle 'list-style-type' scssstyle tcssresword
scssstyle 'margin' scssstyle tcssresword
scssstyle 'margin-bottom' scssstyle tcssresword
scssstyle 'margin-left' scssstyle tcssresword
scssstyle 'margin-right' scssstyle tcssresword
scssstyle 'margin-top' scssstyle tcssresword
scssstyle 'marker-offset' scssstyle tcssresword
scssstyle 'marks' scssstyle tcssresword
scssstyle 'max-height' scssstyle tcssresword
scssstyle 'max-width' scssstyle tcssresword
scssstyle 'min-height' scssstyle tcssresword
scssstyle 'min-width' scssstyle tcssresword
scssstyle 'orphans' scssstyle tcssresword
scssstyle 'outline' scssstyle tcssresword
scssstyle 'outline-color' scssstyle tcssresword
scssstyle 'outline-style' scssstyle tcssresword
scssstyle 'outline-width' scssstyle tcssresword
scssstyle 'overflow' scssstyle tcssresword
scssstyle 'padding' scssstyle tcssresword
scssstyle 'padding-bottom' scssstyle tcssresword
scssstyle 'padding-left' scssstyle tcssresword
scssstyle 'padding-right' scssstyle tcssresword
scssstyle 'padding-top' scssstyle tcssresword
scssstyle 'page' scssstyle tcssresword
scssstyle 'page-break-after' scssstyle tcssresword
scssstyle 'page-break-before' scssstyle tcssresword
scssstyle 'page-break-inside' scssstyle tcssresword
scssstyle 'pause' scssstyle tcssresword
scssstyle 'pause-after' scssstyle tcssresword
scssstyle 'pause-before' scssstyle tcssresword
scssstyle 'pitch' scssstyle tcssresword
scssstyle 'pitch-range' scssstyle tcssresword
scssstyle 'play-during' scssstyle tcssresword
scssstyle 'position' scssstyle tcssresword
scssstyle 'quotes' scssstyle tcssresword
scssstyle 'richness' scssstyle tcssresword
scssstyle 'right' scssstyle tcssresword
scssstyle 'size' scssstyle tcssresword
scssstyle 'speak' scssstyle tcssresword
scssstyle 'speak-header' scssstyle tcssresword
scssstyle 'speak-numeral' scssstyle tcssresword
scssstyle 'speak-punctuation' scssstyle tcssresword
scssstyle 'speech-rate' scssstyle tcssresword
scssstyle 'stress' scssstyle tcssresword
scssstyle 'table-layout' scssstyle tcssresword
scssstyle 'text-align' scssstyle tcssresword
scssstyle 'text-decoration' scssstyle tcssresword
scssstyle 'text-indent' scssstyle tcssresword
scssstyle 'text-shadow' scssstyle tcssresword
scssstyle 'text-transform' scssstyle tcssresword
scssstyle 'top' scssstyle tcssresword
scssstyle 'unicode-bidi' scssstyle tcssresword
scssstyle 'vertical-align' scssstyle tcssresword
scssstyle 'visibility' scssstyle tcssresword
scssstyle 'voice-family' scssstyle tcssresword
scssstyle 'volume' scssstyle tcssresword
scssstyle 'white-space' scssstyle tcssresword
scssstyle 'widows' scssstyle tcssresword
scssstyle 'width' scssstyle tcssresword
scssstyle 'word-spacing' scssstyle tcssresword
scssstyle 'z-index' scssstyle tcssresword

//CSS@@@

// numbers

scssvalue [0-9]*                            scssvalue  tcssinteger
scssvalue \#[0-9A-F]+                       scssvalue  tcssinteger
scssvalue [0-9]*\.[0-9]*                    scssvalue  tcssfloat
scssvalue [0-9]*{\.[0-9]+}|e{[\+\-]}|[0-9]+ scssvalue  tcssfloat

//comments

scssnormal   <\!--                 scssnormal  tcsscomment
scssstyle   <\!--                  scssstyle   tcsscomment
scssvalue   <\!--                  scssvalue   tcsscomment
scssnormal  -->                    scssnormal  tcsscomment
scssstyle  -->                     scssstyle   tcsscomment
scssvalue  -->                     scssvalue   tcsscomment

scssnormal   /\*                   scsscomment2  tcsscomment
scsscomment2 [^\*]*                scsscomment2  tcsscomment
scsscomment2 \*[^/]                scsscomment2  tcsscomment
scsscomment2 [\*]*/                scssnormal    tcsscomment

scssstyle    /\*                   scsscomment4  tcsscomment
scsscomment4 [^\*]*                scsscomment4  tcsscomment
scsscomment4 \*[^/]                scsscomment4  tcsscomment
scsscomment4 [\*]*/                scssstyle     tcsscomment

scssvalue    /\*                   scsscomment6  tcsscomment
scsscomment6 [^\*]*                scsscomment6  tcsscomment
scsscomment6 \*[^/]                scsscomment6  tcsscomment
scsscomment6 [\*]*/                scssvalue     tcsscomment

//strings

scssvalue     \"                   scssstring1    tcssstring
scssstring1    [^\"]*              scssstring1    tcssstring
scssstring1    \"                  scssvalue      tcssstring
scssstring1    \"\"                scssstring1    tcssstring
scssstring1    $                   scssvalue      tcssstring

scssvalue      \'                  scssstring2    tcssstring
scssstring2    [^\']*              scssstring2    tcssstring
scssstring2    \'                  scssvalue      tcssstring
scssstring2    \'\'                scssstring2    tcssstring
scssstring2    $                   scssvalue      tcssstring


// JS  -------------------------------------------------------------------------

//symbols  (must be before switch)
sjsnormal  [<>()\[\]\{\}\.,=;&|]     sjsnormal    tjssymbol

// switch
snormal <script                    shtmlJS     thtmlscript
shtmlJS [^>^\"]*                   shtmlJS     thtmlscript
shtmlJS >                          sjsnormal   thtmlscript
sjsnormal </script>                snormal     thtmlscript

shtmlJS  \"                        shtmlJSval   thtmlscript
shtmlJSval  [^\"]*                 shtmlJSval   thtmlscript
shtmlJSval  \"                     shtmlJS      thtmlscript

// reswords
sjsnormal 'break'        sjsnormal tjsresword
sjsnormal 'case'         sjsnormal tjsresword
sjsnormal 'catch'        sjsnormal tjsresword
sjsnormal 'class'        sjsnormal tjsresword
sjsnormal 'const'        sjsnormal tjsresword
sjsnormal 'continue'     sjsnormal tjsresword
sjsnormal 'debugger'     sjsnormal tjsresword
sjsnormal 'default'      sjsnormal tjsresword
sjsnormal 'delete'       sjsnormal tjsresword
sjsnormal 'do'           sjsnormal tjsresword
sjsnormal 'else'         sjsnormal tjsresword
sjsnormal 'enum'         sjsnormal tjsresword
sjsnormal 'export'       sjsnormal tjsresword
sjsnormal 'extends'      sjsnormal tjsresword
sjsnormal 'false'        sjsnormal tjsresword
sjsnormal 'finally'      sjsnormal tjsresword
sjsnormal 'for'          sjsnormal tjsresword
sjsnormal 'function'     sjsnormal tjsresword
sjsnormal 'if'           sjsnormal tjsresword
sjsnormal 'import'       sjsnormal tjsresword
sjsnormal 'in'           sjsnormal tjsresword
sjsnormal 'new'          sjsnormal tjsresword
sjsnormal 'null'         sjsnormal tjsresword
sjsnormal 'return'       sjsnormal tjsresword
sjsnormal 'super'        sjsnormal tjsresword
sjsnormal 'switch'       sjsnormal tjsresword
sjsnormal 'this'         sjsnormal tjsresword
sjsnormal 'throw'        sjsnormal tjsresword
sjsnormal 'true'         sjsnormal tjsresword
sjsnormal 'try'          sjsnormal tjsresword
sjsnormal 'typeof'       sjsnormal tjsresword
sjsnormal 'var'          sjsnormal tjsresword
sjsnormal 'void'         sjsnormal tjsresword
sjsnormal 'while'        sjsnormal tjsresword
sjsnormal 'with'         sjsnormal tjsresword

// numbers
sjsnormal [0-9][0-9]*                            sjsnormal  tjsinteger
sjsnormal 0X[0-9A-F]+                            sjsnormal  tjsinteger
sjsnormal [1-9][0-9]*\.[0-9]*                    sjsnormal  tjsfloat
sjsnormal [1-9][0-9]*{\.[0-9]+}|e{[\+\-]}|[0-9]+ sjsnormal  tjsfloat

// idents
sjsnormal   [a-z_A-Z][a-z_A-Z0-9]*  sjsnormal   tjsident

//white space
sjsnormal #32*                      sjsnormal   twhitespace


//strings
sjsnormal    \'                     sjsstring1   tjsstring
sjsstring1   [^\']*                 sjsstring1   tjsstring
sjsstring1   \'                     sjsnormal    tjsstring
sjsstring1   \'\'                   sjsstring1   tjsstring
sjsstring1   \\                     sjsstring1   tjsstring
sjsstring1   \\\'                   sjsstring1   tjsstring
sjsstring1   $                      sjsnormal    tjsstring

//strings
sjsnormal     \"                    sjsstring2   tjsstring
sjsstring2   [^\"]*                 sjsstring2   tjsstring
sjsstring2   \"                     sjsnormal    tjsstring
sjsstring2   \"\"                   sjsstring2   tjsstring
sjsstring2   \\                     sjsstring2   tjsstring
sjsstring2   \\\"                   sjsstring2   tjsstring
sjsstring2   $                      sjsnormal    tjsstring

//comments
sjsnormal   //                      sjscomment1  tjscomment
sjscomment1 [^\-]*                  sjscomment1  tjscomment
sjscomment1 [\-]*[^>]               sjscomment1  tjscomment
sjscomment1 [\-]*>                  sjsnormal    tjscomment
sjscomment1 $                       sjsnormal    tjscomment

sjsnormal   /\*                     sjscomment2  tjscomment
sjscomment2 [^\*]*                  sjscomment2  tjscomment
sjscomment2 \*[^/]                  sjscomment2  tjscomment
sjscomment2 [\*]*/                  sjsnormal    tjscomment

 
 
