﻿
//创建GoogleMap
//panelMap - 显示地图的对象区域
//showScale - 是否显示改变大小的控件 true false
//showLargeControl - 是否显示切换控件  true false
//showTypeControl - 是否显示切换显示类型的按钮
//showZoom - 是否显示右下角的小地图
//zoomSize - 视觉距离
var clickListener ;
var GoogleMapCreate = function(panelMap,showScale,showLargeControl,showTypeControl,showZoom,zoomSize,lat,lng){
    myMap = new GMap2(panelMap);
    if(showLargeControl)
    {
        myMap.addControl(new GLargeMapControl());        
    }
    else
    {
         myMap.addControl(new GSmallMapControl());  
    }
    
    
    if(showTypeControl)
    {
        myMap.addControl(new GMapTypeControl());
    }
    
    
    if(showScale)
    {
        myMap.addControl(new GScaleControl());
    }
    
    if(showZoom)
    {
        myMap.addControl(new GOverviewMapControl());
    }
    
    myMap.enableDoubleClickZoom();
	myMap.enableContinuousZoom();
    
    myMap.setCenter(new GLatLng(lat,lng), zoomSize,G_NORMAL_MAP);
    return myMap;
};

var GoogleMapAddEvent = function(myMap,eventName,fun){
    clickListener = GEvent.addListener(myMap,eventName,fun);
};

var GoogleMapRemoveEvent = function(myMap,eventName){
    GEvent.removeListener(clickListener);
};


//在指定坐标上显示tip提示
var GoogleMapShowTip = function(myMap,point,text){
    myMap.openInfoWindow(point,document.createTextNode(text));
};


//在指定坐标上加入地标
var GoogleMapNewMarker = function(myMap,point){
    var marker = new GMarker(point);
    myMap.addOverlay(marker);
    return marker;
};

//根据坐标点取得X坐标
var GoogleMapPointX = function(point){
    return point.lat();
};

//根据坐标点取得Y坐标
var GoogleMapPointY = function(point){
    return point.lng();
};
