﻿
using System;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Collections;
using System.Collections.Generic;

using Newtonsoft.Json;
using Legalsoft.Workflow.Application;

public partial class _Utility_Summary : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.ContentType = "text/html;charset=UTF-8";
        Response.Write(Baby.Summary());
        Response.Write(Commands.Summary());
        Response.Write(Tracer.Summary());

        try
        {
            string memo = Networks.Download(Baby.RemoteUrl + "roles/", Baby.EncoderName, 30);
            List<_role_info> roles = JsonConvert.DeserializeObject<List<_role_info>>(memo);
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("<span class=\"information\" id=\"flows_info\">");
            sb.AppendLine("There are " + roles.Count + " flow models.<br>");
            if (roles.Count > 0)
            {
                sb.AppendLine("<table width=\"0%\" border=1>");
                sb.AppendLine("<tr style=\"background-color:#EEEEFF;\"><td>flow</td><td>node_id</td><td>node_name</td><td>node_role</td><td></td></tr>");
                foreach (_role_info cx in roles)
                {
                    sb.AppendLine("<tr>");
                    sb.AppendLine("<td>" + cx.flow_name + "</td>");
                    sb.AppendLine("<td>" + cx.node_id + "</td>");
                    sb.AppendLine("<td>" + cx.node_name + "</td>");
                    sb.AppendLine("<td>" + cx.node_role + "</td>");
                    sb.AppendLine("<td><a href=\"javascript:void(0)\" onclick=\"start('0','" + cx.flow_name + "','" + cx.node_id + "','" + cx.node_name + "','" + cx.node_role + "')\">&gt;&gt;&gt;</a></td>");
                    sb.AppendLine("<tr>");
                }
                sb.AppendLine("</table>");
            }
            sb.AppendLine("</span>");
            Response.Write(sb.ToString());
        }
        catch (Exception ex)
        {
            Response.Write("<span class=\"information\" id=\"flows_info\">" + ex.Message + "</span>");
        }

        try
        {
            string memo = Networks.Download(Baby.RemoteUrl + "flows/", Baby.EncoderName, 30);
            List<_instances_info> Items = JsonConvert.DeserializeObject<List<_instances_info>>(memo);
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("<span class=\"information\" id=\"instances_info\">");
            sb.AppendLine("There are " + Items.Count + " flow instances.<br>");
            if (Items.Count > 0)
            {
                sb.AppendLine("<table width=\"0%\" border=1>");
                sb.AppendLine("<tr style=\"background-color:#EEEEFF;\"><td>Name</td><td>Id</td><td></td><td></td></tr>");
                foreach (_instances_info cx in Items)
                {
                    sb.AppendLine("<tr>");
                    sb.AppendLine("<td>" + cx.FlowName + "</td>");
                    sb.AppendLine("<td>" + cx.FlowId + "</td>");
                    sb.AppendLine("<td><a href=\"javascript:void(0)\" onclick=\"progress(" + cx.FlowId + ")\">Progress Image</a></td>");
                    sb.AppendLine("<td><a href=\"javascript:void(0)\" onclick=\"timeline(" + cx.FlowId + ")\">Timeline</a></td>");
                    sb.AppendLine("</tr>");
                }
                sb.AppendLine("</table>");
            }
            sb.AppendLine("</span>");
            Response.Write(sb.ToString());
        }
        catch (Exception ex)
        {
            Response.Write("<span class=\"information\" id=\"instances_info\">" + Baby.RemoteUrl + "/flows/" + " ERROR:" + ex.Message + "</span>");
        }
    }
}

public class _role_info
{
    public string flow_name { set; get; }
    public string node_id { set; get; }
    public string node_name { set; get; }
    public string node_role { set; get; }
}

public class _instances_info
{
	public string FlowName { set; get; }
	public int FlowId { set; get; }
}

