﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Home_Default" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Legalsoft Workflow Simulate</title>
<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta http-equiv="content-language" content="zh-cn" />
<meta http-equiv="imagetoolbar" content="no" />
<meta name="distribution" content="global" />
<script language="javascript" src="/common/jquery-1.8.1.min.js"></script>
<script language="javascript" src="/common/jpopup.js"></script>
<script language="javascript" src="/common/jhelp.js"></script>
</head>
<body>
<style>
* { font-family:Courier new; }
body { padding:0px;margin:0px; }
table { border-collapse:collapse; }
td { padding:10px;text-align:left;white-space:nowrap; }
input[type='radio'] { cursor:pointer; }
input,textarea { padding:5px; }

.tool { width:100px;height:60px;margin-bottom:5px;cursor:pointer;border-bottom:solid 1px #FFFFFF;line-height:60px;text-align:center;font-size:16px;border:solid 1px #EEEEEE;border-radius:10px; } 
.tool:hover { background-color: #5487BC;color:#FFFFFF; }

#title { color:#FFFFFF;font-size:16px; }
#summary_info { padding:20px;line-height:23px; }

.popBody { position:absolute;left:0px;top:0px;filter:alpha(opacity=50);opacity:0.50;background-color:#666666;z-index:101; }
.popMsg  { position:absolute;background-color:#FFFFFF;font-size:12p;text-align:center;line-height:22px;z-index:102;border:solid 1px #FFFFFF;border-radius:10px;overflow:hidden; }
.popBar { height:22px;line-height:22px;text-align:center;padding:3px;margin:0px;font-size:14px;color:#FFFFFF;cursor:move;background-color:#666699; }
.popBtn { float:right;width:40px;cursor:pointer;color:#FFFF00;font-weight:bold; }
.popWin { clear:both;padding:10px; }

</style>
<table id="contex" width="100%">
	<tr style="background-color: #5487BC; height:51px;">
		<td style="width: 100px;color:#FFFF00;font-size:12px;text-align:center;">FlowStudio&copy;</td>
		<td id="title" style="" colspan="2"></td>
	</tr>
	<tr>
		<td id="left_commands" style="background-color: #E4E4E4; width: 100px;" valign="top"></td>
		<td valign="top" id="summary_info"></td>
		<td valign="top">
			<input type="hidden" id="remote_url" name="remote_url" value="<% =remote_url %>">
			<span id="echo_info"></span><br>
			<span id="graph_info"></span>
		</td>
	</tr>
</table>
<script language="javascript">

// 待处理的“消息ID”
var send_command_index = "";
function timer_handler()
{
	$.get("/include/summary.aspx", { rnd : Math.random() }, function(result) {
		$("#summary_info").html(Now() + "<br><br>" + help_string() + result);
		// 如果有待处理的消息，则马上去执行！
		if(send_command_index.length == 0) {
			if($("#send_command_index").length > 0) { 
				send_command_index = $("#send_command_index").val();
				forward(send_command_index); 
			}
		}
		// 页面信息（按last_command约定的默认选项）
		PAGE(null);
	});
}

timer_handler();
setInterval("timer_handler()", 2017);

// 按last_command为选项显示/include/summary.aspx获取的各类信息
var last_command = "welcome";
function PAGE(obj)
{
	$(".information").each(function() { $(this).css("display","none"); });
	if(obj != null) { 
		last_command = obj.title.toLowerCase(); 
		$("#" + last_command + "_info").css("display",""); 
	}
	else {
		if(last_command.length > 0) {
			$("#" + last_command + "_info").css("display",""); 
		}
	}
}

// 弹出窗口，从流程模板列表中，选择一个流程模板；
// 通知“工作流引擎”启动流程（创建一个实例）；
function start(flow_id,flow_name,node_id,node_name,node_role)
{
    $.get("/include/start.aspx", { 
		flow_id: flow_id, 
		flow_name: flow_name, 
		node_id: node_id, 
		node_name: node_name, 
		node_role: node_role, 
		rnd: Math.random() 
	}, function (result) {
        PopupShow(800, 600, "start flow(" + flow_name + ")", "");
        $("#popup_inner").html(result);
    });
}

// 点击流程启动的“提交”
function start_action()
{
	if ($("#MemberId").val().length == 0 || $("#MemberName").val().length == 0) {
		alert("Please input MemberID & MemberName.!");
		return;
	}

	$.get("/include/start_prc.aspx", {
		FlowName: $("#FlowName").val(),
		FlowId: $("#FlowId").val(),
		NodeName: $("#NodeName").val(),
		NodeId: $("#NodeId").val(),
		Role: $("#Role").val(),
		MemberId: $("#MemberId").val(),
		MemberName: $("#MemberName").val(),
		Operation: $("#Operation").val(),
		ParaName: $("#ParaName").val(),
		ParaValue: $("#ParaValue").val(),
		rnd: Math.random()
	},
	function(result) {
		PopupClose();
	});
}

// 接收到消息Command后，模拟弹出“批准”窗口；
function forward(flow_id)
{
	$.get("/include/forward.aspx", {
		id: flow_id,
		rnd: Math.random()
	},
	function(result) {
		PopupShow(800, 600, "work flow forward", "");
		$("#popup_inner").html(result);
	});
}

// 点击批准页面的“提交”
function forward_action()
{
	if ($("#MemberId").val().length == 0 || $("#MemberName").val().length == 0) {
		alert("Please input MemberID & MemberName.!");
		return;
	}
	if ($("input:radio[name='Decision'][checked]").val() == null) {
		alert("Please make your decision!");
		return;
	}

	$.get("/include/forward_prc.aspx", {
		Id: $("#Id").val(),
		FlowName: $("#FlowName").val(),
		FlowId: $("#FlowId").val(),
		NodeName: $("#NodeName").val(),
		NodeId: $("#NodeId").val(),
		Role: $("#Role").val(),
		MemberId: $("#MemberId").val(),
		MemberName: $("#MemberName").val(),
		Decision: $("#Decision").val(),
		Operation: $("#Operation").val(),
		ParaName: $("#ParaName").val(),
		ParaValue: $("#ParaValue").val(),
		rnd: Math.random()
	},
	function(result) {
		send_command_index = "";
		PopupClose();
	});
}

$(document).ready(function () {
	$("#contex").height($(document).height());
});

// 显示制定“流程实例”的进度图
// 也可以才应用系统中以嵌入这个图！
// 遵循 RESTful
function progress(id)
{
	var vrnd = Math.random();
	$("#graph_info").html("<img src='" + $("#remote_url").val() + "flow/progress/" + id + "?rnd=" + vrnd + "'>");
	$("#echo_info").html("" + $("#remote_url").val() + "flow/progress/" + id);
}

// 显示制定“流程实例”的“时间轴timeline”
// 也可以才应用系统中以嵌入这个数据！
// 遵循 RESTful
function timeline(id)
{
	var vrnd = Math.random();
	$.get("/include/timeline.aspx", {
		id: id,
		rnd: vrnd
	},
	function(result) {
		$("#graph_info").html(result);
		$("#echo_info").html("" + $("#remote_url").val() + "flow/timeline/" + id);
	});
}

function I2(v) {
	return (v < 10) ? "0" + v: v;
}
function Now() {
	var t = new Date();
	return t.getFullYear() + "-" + I2(t.getMonth() + 1) + "-" + I2(t.getDate()) + " " + I2(t.getHours()) + ":" + I2(t.getMinutes()) + ":" + I2(t.getSeconds());
}

</script>
</body>
</html>
