﻿
function GetAbsolutePosition(e) {
    var left = 0;
    var top = 0;
    var scroll = e;
    while (e) {
        left += e.offsetLeft;
        top += e.offsetTop;
        e = e.offsetParent;
    }

    while (scroll) {
        if (scroll.scrollLeft) { left -= scroll.scrollLeft; }
        if (scroll.scrollTop) { top -= scroll.scrollTop; }
        scroll = scroll.parentElement;
    }
    return { X: left, Y: top }
}

function PopupShow(w, h, title, url) {
    var iWidth = document.documentElement.clientWidth;
    var iHeight = Math.max(document.documentElement.clientHeight, document.body.scrollHeight);
    var bgObj = document.createElement("div");
    bgObj.id = "popBody";
    bgObj.className = "popBody";
    bgObj.style.cssText = "width:100%;height:" + iHeight + "px;";
    document.body.appendChild(bgObj);

    var msgObj = document.createElement("div");
    msgObj.id = "popMsg";
    msgObj.className = "popMsg";
    msgObj.style.cssText = "width:" + w + "px;height:" + h + "px;";
    document.body.appendChild(msgObj);

    var barObj = document.createElement("div");
    barObj.className = "popBar";
    msgObj.appendChild(barObj);

    var titleObj = document.createElement("div");
    titleObj.id = "popTitle";
    titleObj.innerHTML = title;
    titleObj.style.cssText = "float:left;width:" + (w - 50) + "px;";
    barObj.appendChild(titleObj);

    var moveX = 0;
    var moveY = 0;
    var moveTop = 0;
    var moveLeft = 0;
    var moveable = false;

    var docMouseMoveEvent = document.onmousemove;
    var docMouseUpEvent = document.onmouseup;

    barObj.onmousedown = function (e) {
        e = e || event;
        moveable = true;
        moveX = e.clientX;
        moveY = e.clientY;
        moveTop = parseInt(msgObj.style.top);
        moveLeft = parseInt(msgObj.style.left);

        document.onmousemove = function (e) {
            if (moveable) {
                e = e || event;
                var x = moveLeft + e.clientX - moveX;
                var y = moveTop + e.clientY - moveY;
                if (x > 0 && (x + w < iWidth) && y > 0 && (y + h < iHeight)) {
                    msgObj.style.left = x + "px";
                    msgObj.style.top = y + "px";
                }
            }
        };

        document.onmouseup = function (e) {
            if (moveable) {
                document.onmousemove = docMouseMoveEvent;
                document.onmouseup = docMouseUpEvent;
                moveable = false;
                moveX = 0;
                moveY = 0;
                moveTop = 0;
                moveLeft = 0;
            }
        };
    }

    var btnObj = document.createElement("div");
    btnObj.className = "popBtn";
    btnObj.innerHTML = "[X]";
    barObj.appendChild(btnObj);
    btnObj.onclick = function () {
        document.body.removeChild(bgObj);
        document.body.removeChild(msgObj);
    }

    document.onkeyup = function (e) {
        e = e || event;
        var key = e.keyCode || e.which || e.charCode;
        if (key == 27) {
            document.body.removeChild(bgObj);
            document.body.removeChild(msgObj);
        }
    }

    var urlObj = document.createElement("div");
    urlObj.id = "popup_inner";
    urlObj.className = "popWin";
    if (url.length > 0) urlObj.innerHTML = "<iframe src=\"" + url + "\" width=\"" + (w - 16) + "\" height=\"" + (h - 22 - 16) + "\" frameborder=\"no\" scrolling=\"no\"></iframe>";
    msgObj.appendChild(urlObj);

    function window_size() {
        var top = document.documentElement.scrollTop + document.body.scrollTop;
        var left = document.documentElement.scrollLeft;
        var width = document.documentElement.clientWidth;
        var height = document.documentElement.clientHeight;
        return { top: top, left: left, height: height, width: width };
    }

    window.onscroll = function () {
        var size = window_size();
        var leftadd = (size.width - w) / 2;
        var topadd = (size.height - h) / 2;

        msgObj.style.top = (size.top + topadd) + "px";
        msgObj.style.left = (size.left + leftadd) + "px";
    }

    window.onresize = window.onscroll;
    window.onscroll();
}

function removeElement(_element) {
    var _parentElement = _element.parentNode;
    if (_parentElement) {
        _parentElement.removeChild(_element);
    }
}

function PopupClose() {
    var bgObj = document.getElementById("popBody");
    if (bgObj != null) document.body.removeChild(bgObj);
    var msgObj = document.getElementById("popMsg");
    if (msgObj != null) document.body.removeChild(msgObj);
}

function PopupTitle(title) {
    var titleObj = document.getElementById("popTitle");
    if (titleObj != null) titleObj.innerHTML = title;
}

