﻿using System;
using System.Text;
using System.Web;
using System.Net;
using System.Collections;
using System.Collections.Specialized;
using System.Collections.Generic;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

namespace Legalsoft.Workflow.Application
{
    /// <summary>
    /// Web基础信息
    /// </summary>
    public static class WebHelper
    {
        /// <summary>
        /// 当前Request对象
        /// </summary>
        public static HttpRequest Request
        {
            get
            {
                return HttpContext.Current.Request;
            }
        }

        /// <summary>
        /// 当前Response对象
        /// </summary>
        public static HttpResponse Response
        {
            get
            {
                return HttpContext.Current.Response;
            }
        }

        /// <summary>
        /// 当前Server对象
        /// </summary>
        public static HttpServerUtility Server
        {
            get
            {
                return HttpContext.Current.Server;
            }
        }

        public static string LocalAddr
        {
            get
            {
                if (Request.ServerVariables["LOCAL_ADDR"] != null)
                {
                    return Request.ServerVariables["LOCAL_ADDR"].ToString();
                }
                return "";
            }
        }

        public static string HttpReferer
        {
            get
            {
                if (Request.ServerVariables["HTTP_REFERER"] != null)
                {
                    return Request.ServerVariables["HTTP_REFERER"].ToString();
                }
                return "";
            }
        }

        public static string HttpHost
        {
            get
            {
                if (Request.ServerVariables["HTTP_HOST"] != null)
                {
                    return Request.ServerVariables["HTTP_HOST"].ToString();
                }
                return "";
            }
        }

        public static int ServerPort
        {
            get
            {
                int port = 80;
                if (Request.ServerVariables["SERVER_PORT"] != null)
                {
                    return Int32.Parse(Request.ServerVariables["SERVER_PORT"].ToString());
                }
                return port;
            }
        }

        public static string HostPath
        {
            get
            {
                return Server.MapPath("/");
            }
        }

        /// <summary>
        /// 获得用户的真实 IP
        /// </summary>
        /// <returns></returns>
        public static string ClientIP
        {
            get
            {
                return Request.UserHostAddress;
            }
        }

        /// <summary>
        /// 当前程序名
        /// </summary>
        /// <returns></returns>
        public static string ScriptName
        {
            get
            {
                if (Request.ServerVariables["SCRIPT_NAME"] != null)
                {
                    return Request.ServerVariables["SCRIPT_NAME"].ToString();
                }
                return "";
            }
        }
    }
}
