﻿
using System;
using System.IO;
using System.Text;
using System.Net;
using System.Net.NetworkInformation;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace Legalsoft.Workflow.Application
{
    public static class Networks
    {
        /// <summary>
        /// 从指定地址下载网页信息
        /// </summary>
        /// <param name="url"></param>
        /// <param name="encoder">编码</param>
        /// <param name="timeoutSeconds">超时时间（秒）</param>
        /// <returns></returns>
        public static string Download(string url, string encoder, int timeoutSeconds)
        {
            if (url.Length < 1) return "";
            if (!url.ToLower().StartsWith("http://")) return "";
            try
            {
                string rsl = "";
                Encoding encoding = Encoding.GetEncoding(encoder);
                HttpWebRequest myWebRequest = (HttpWebRequest)HttpWebRequest.Create(new Uri(url));
                myWebRequest.Timeout = timeoutSeconds * 1000;
                using (HttpWebResponse myWebResponse = (HttpWebResponse)myWebRequest.GetResponse())
                {
                    using (StreamReader sr = new StreamReader(myWebResponse.GetResponseStream(), encoding))
                    {
                        rsl = sr.ReadToEnd();
                    }
                    myWebResponse.Close();
                }
                return rsl;
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }
    }
}
